/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.sap.extension.internal.mapping;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.mule.modules.sap.extension.internal.exception.mapping.SapXmlParserException;
import org.mule.modules.sap.extension.internal.mapping.NodeListIterable;
import org.mule.modules.sap.extension.internal.mapping.SapNameEncoder;
import org.mule.modules.sap.extension.internal.mapping.SapXmlTransformer;
import org.mule.modules.sap.extension.internal.mapping.XMLBuilder;
import org.mule.modules.sap.extension.internal.model.function.AbapInternalException;
import org.mule.modules.sap.extension.internal.model.function.BAPIFunction;
import org.mule.modules.sap.extension.internal.model.function.Field;
import org.mule.modules.sap.extension.internal.model.function.ParameterField;
import org.mule.modules.sap.extension.internal.model.function.Structure;
import org.mule.modules.sap.extension.internal.model.function.Table;
import org.mule.modules.sap.extension.internal.model.metadata.Metadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class BAPIFunctionXmlTransformer
implements SapXmlTransformer<BAPIFunction> {
    protected static final String IMPORT_TAG = "import";
    protected static final String EXPORT_TAG = "export";
    protected static final String TABLES_TAG = "tables";
    protected static final String CHANGING_TAG = "changing";
    private static final Logger logger = LoggerFactory.getLogger(BAPIFunctionXmlTransformer.class);

    @Override
    public InputStream toXml(BAPIFunction function, String encoding) {
        try {
            Document xml = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element root = xml.createElement(SapNameEncoder.encodeSapObjectName(function.getFunctionName()));
            this.parse(IMPORT_TAG, xml, root, function.getImportParameters());
            this.parse(EXPORT_TAG, xml, root, function.getExportParameters());
            this.parse(TABLES_TAG, xml, root, function.getTableParameters());
            this.parse(CHANGING_TAG, xml, root, function.getChangingParameters());
            xml.appendChild(root);
            return this.writeXml(xml);
        }
        catch (ParserConfigurationException | TransformerException e) {
            throw new SapXmlParserException(e);
        }
    }

    private void parse(String name, Document document, Element root, List<ParameterField> list) {
        if (!list.isEmpty()) {
            Element listElement = document.createElement(name);
            for (ParameterField field : list) {
                Element fieldElement = document.createElement(field.getName());
                field.accept(new XMLBuilder(fieldElement));
                listElement.appendChild(fieldElement);
            }
            root.appendChild(listElement);
        }
    }

    @Override
    public InputStream getXmlSchema(Metadata metadata, String encoding) {
        try {
            Document schema = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element root = schema.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:schema");
            root.setAttribute("version", "1.0");
            metadata.appendTo(root);
            schema.appendChild(root);
            return this.writeXml(schema);
        }
        catch (ParserConfigurationException | TransformerException e) {
            throw new SapXmlParserException(e);
        }
    }

    private ParameterField parse(Node node) {
        ParameterField field;
        ArrayList<Node> children = new ArrayList<Node>();
        for (Node child : NodeListIterable.from(node.getChildNodes())) {
            if (child.getNodeType() != 1) continue;
            children.add(child);
        }
        if (children.isEmpty()) {
            field = new Field(node.getNodeName(), node.getTextContent());
        } else if (((Node)children.get(0)).getNodeName().equalsIgnoreCase("ROW")) {
            Table table = new Table(node.getNodeName());
            for (Node child : children) {
                table.add((Structure)Structure.class.cast(this.parse(child)));
            }
            field = table;
        } else {
            Structure structure = new Structure(node.getNodeName());
            for (Node child : children) {
                structure.add(this.parse(child));
            }
            field = structure;
        }
        return field;
    }

    private List<ParameterField> parse(String name, Document document) {
        ArrayList<ParameterField> parameterFields = new ArrayList<ParameterField>();
        for (Node node : NodeListIterable.from(document.getElementsByTagName(name))) {
            for (Node child : NodeListIterable.from(node.getChildNodes())) {
                if (child.getNodeType() != 1) continue;
                parameterFields.add(this.parse(child));
            }
        }
        return parameterFields;
    }

    @Override
    public BAPIFunction fromXml(InputStream xml, String encoding) throws SapXmlParserException {
        try {
            if (xml == null) {
                return null;
            }
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            documentBuilderFactory.setXIncludeAware(false);
            documentBuilderFactory.setExpandEntityReferences(false);
            Document document = documentBuilderFactory.newDocumentBuilder().parse(xml);
            BAPIFunction function = new BAPIFunction(document.getFirstChild().getNodeName());
            if (function.getFunctionName().equals("jco")) {
                throw new SapXmlParserException("V1 format is not accepted.");
            }
            function.getImportParameters().addAll(this.parse(IMPORT_TAG, document));
            function.getExportParameters().addAll(this.parse(EXPORT_TAG, document));
            function.getChangingParameters().addAll(this.parse(CHANGING_TAG, document));
            function.getTableParameters().addAll(this.parse(TABLES_TAG, document));
            for (Node errorNode : NodeListIterable.from(document.getElementsByTagName("exception"))) {
                NamedNodeMap attributes = errorNode.getAttributes();
                String errorKey = attributes.getNamedItem("key").getTextContent();
                String messageClass = attributes.getNamedItem("messageClass").getTextContent();
                String messageType = attributes.getNamedItem("messageType").getTextContent();
                String messageNumber = attributes.getNamedItem("messageNumber").getTextContent();
                ArrayList<String> messageParameters = new ArrayList<String>();
                String message = errorNode.getTextContent();
                if (messageNumber != null) {
                    for (Node child : NodeListIterable.from(errorNode.getChildNodes())) {
                        messageParameters.add(child.getTextContent());
                    }
                }
                logger.debug("Building AbapException for errorKey={}, messageClass={}, messageType={}, messageParameters={}, message={}", new Object[]{errorKey, messageClass, messageType, messageParameters, message});
                function.getExceptionList().add(new AbapInternalException(errorKey, messageClass, messageNumber, message));
            }
            return function;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new SapXmlParserException(e);
        }
    }

    private InputStream writeXml(Document document) throws TransformerException {
        StringWriter stringWriter = new StringWriter();
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.transform(new DOMSource(document), new StreamResult(stringWriter));
        return new ByteArrayInputStream(stringWriter.toString().getBytes(Charset.forName("UTF-8")));
    }
}

