/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.sap.extension.internal.mapping;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import org.mule.modules.sap.extension.internal.exception.mapping.SapXmlParserException;
import org.mule.modules.sap.extension.internal.mapping.BAPIFunctionXmlTransformer;
import org.mule.modules.sap.extension.internal.model.function.BAPIFunction;
import org.mule.modules.sap.extension.internal.model.function.Field;
import org.mule.modules.sap.extension.internal.model.function.ParameterField;
import org.mule.modules.sap.extension.internal.model.function.Structure;
import org.mule.modules.sap.extension.internal.model.function.Table;
import org.mule.modules.sap.extension.internal.util.XMLChar;
import org.mule.runtime.core.api.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BapiFunctionStaxXmlTransformer
extends BAPIFunctionXmlTransformer {
    private static final String ID = "id";
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final String SLASH = "/";
    private static final String SLASH_ESCAPE = "_-";
    private static final char DEFAULT_ESCAPE = '_';
    private static final Logger logger = LoggerFactory.getLogger(BapiFunctionStaxXmlTransformer.class);

    @Override
    public InputStream toXml(BAPIFunction function, String encoding) {
        String enc = StringUtils.isEmpty((String)encoding) ? DEFAULT_ENCODING : encoding;
        logger.debug("About to transform function: {} using encoding: {} and given encoding {}!", new Object[]{function.getFunctionName(), encoding, enc});
        StringWriter stringWriter = new StringWriter();
        String functionName = function.getFunctionName();
        functionName = functionName.replaceAll(SLASH, SLASH_ESCAPE);
        function.setFunctionName(functionName);
        ByteArrayOutputStream stream = new ByteArrayOutputStream(){

            @Override
            public synchronized byte[] toByteArray() {
                return this.buf;
            }
        };
        XMLOutputFactory xMLOutputFactory = XMLOutputFactory.newInstance();
        XMLStreamWriter xMLStreamWriter = null;
        try {
            xMLStreamWriter = xMLOutputFactory.createXMLStreamWriter(stream, enc);
            xMLStreamWriter.writeStartDocument();
            xMLStreamWriter.writeStartElement(function.getFunctionName());
            this.startSerialize(xMLStreamWriter, function.getImportParameters(), "import");
            this.startSerialize(xMLStreamWriter, function.getExportParameters(), "export");
            this.startSerialize(xMLStreamWriter, function.getTableParameters(), "tables");
            this.startSerialize(xMLStreamWriter, function.getChangingParameters(), "changing");
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeEndDocument();
            xMLStreamWriter.flush();
            StAXSource source = new StAXSource(XMLInputFactory.newInstance().createXMLEventReader(new ByteArrayInputStream(stream.toByteArray(), 0, stream.size())));
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", enc);
            transformer.setOutputProperty("standalone", "no");
            transformer.transform(source, new StreamResult(stringWriter));
        }
        catch (XMLStreamException | TransformerException e) {
            throw new SapXmlParserException(e);
        }
        finally {
            try {
                stringWriter.close();
            }
            catch (IOException ignored) {
                logger.warn("Exception occurred while closing stringWriter", (Throwable)ignored);
            }
            try {
                stream.close();
            }
            catch (IOException ignored) {
                logger.warn("Exception occurred while closing stream", (Throwable)ignored);
            }
            if (xMLStreamWriter != null) {
                try {
                    xMLStreamWriter.close();
                }
                catch (XMLStreamException ignored) {
                    logger.warn("Exception occurred while closing stream writer", (Throwable)ignored);
                }
            }
        }
        return new ByteArrayInputStream(stringWriter.toString().getBytes(Charset.forName(enc)));
    }

    private void startSerialize(XMLStreamWriter xMLStreamWriter, List<ParameterField> parameters, String tag) {
        if (parameters == null || parameters.isEmpty() || StringUtils.isBlank((String)this.getEscapedXmlTagName(tag))) {
            return;
        }
        try {
            xMLStreamWriter.writeStartElement(tag);
            this.serialize(xMLStreamWriter, parameters);
            xMLStreamWriter.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new SapXmlParserException(e);
        }
    }

    private void serialize(XMLStreamWriter xMLStreamWriter, List<ParameterField> parameters) throws XMLStreamException {
        for (ParameterField field : parameters) {
            if (field instanceof Table) {
                this.serializeTable(xMLStreamWriter, (Table)field);
                continue;
            }
            if (field instanceof Field) {
                this.serializeField(xMLStreamWriter, (Field)field);
                continue;
            }
            if (!(field instanceof Structure)) continue;
            this.serializeStructure(xMLStreamWriter, (Structure)field);
        }
    }

    private void serializeField(XMLStreamWriter xMLStreamWriter, Field field) {
        if (field == null) {
            return;
        }
        try {
            if (!StringUtils.isBlank((String)this.getEscapedXmlTagName(field.getName()))) {
                xMLStreamWriter.writeStartElement(this.getEscapedXmlTagName(field.getName()));
            }
            if (field.getValue() instanceof ParameterField) {
                this.serialize(xMLStreamWriter, Collections.singletonList((ParameterField)field.getValue()));
            } else if (field.getValue() != null && !StringUtils.isEmpty((String)field.getValue().toString())) {
                xMLStreamWriter.writeCharacters(field.getValue().toString());
            }
            if (!StringUtils.isBlank((String)this.getEscapedXmlTagName(field.getName()))) {
                xMLStreamWriter.writeEndElement();
            }
        }
        catch (XMLStreamException e) {
            throw new SapXmlParserException(e);
        }
    }

    private void serializeStructure(XMLStreamWriter xMLStreamWriter, Structure structure) {
        this.writeStructureToStream(xMLStreamWriter, structure, false, -1);
    }

    private void serializeStructureFromTable(XMLStreamWriter xMLStreamWriter, Structure structure, int rowId) {
        this.writeStructureToStream(xMLStreamWriter, structure, true, rowId);
    }

    private void writeStructureToStream(XMLStreamWriter xMLStreamWriter, Structure structure, boolean isTableStructure, int rowId) {
        if (structure == null) {
            return;
        }
        try {
            if (!StringUtils.isBlank((String)this.getEscapedXmlTagName(structure.getName()))) {
                xMLStreamWriter.writeStartElement(this.getEscapedXmlTagName(structure.getName()));
                if (isTableStructure) {
                    xMLStreamWriter.writeAttribute(ID, String.valueOf(rowId));
                }
            }
            if (structure.getFields() != null && !structure.getFields().isEmpty()) {
                this.serialize(xMLStreamWriter, structure.getFields());
            }
            if (!StringUtils.isBlank((String)this.getEscapedXmlTagName(structure.getName()))) {
                xMLStreamWriter.writeEndElement();
            }
        }
        catch (XMLStreamException e) {
            throw new SapXmlParserException(e);
        }
    }

    private void serializeTable(XMLStreamWriter xMLStreamWriter, Table table) {
        if (table == null) {
            return;
        }
        try {
            if (!StringUtils.isBlank((String)this.getEscapedXmlTagName(table.getName()))) {
                xMLStreamWriter.writeStartElement(this.getEscapedXmlTagName(table.getName()));
            }
            if (table.getRows() != null) {
                int rowId = 0;
                for (Structure structure : table.getRows()) {
                    this.serializeStructureFromTable(xMLStreamWriter, structure, rowId);
                    ++rowId;
                }
            }
            if (!StringUtils.isBlank((String)this.getEscapedXmlTagName(table.getName()))) {
                xMLStreamWriter.writeEndElement();
            }
        }
        catch (XMLStreamException e) {
            throw new SapXmlParserException(e);
        }
    }

    private String getEscapedXmlTagName(String tagName) {
        String ret;
        if (StringUtils.isEmpty((String)tagName)) {
            return tagName;
        }
        String string = ret = tagName.contains(SLASH) ? tagName.replaceAll(SLASH, SLASH_ESCAPE) : tagName;
        if (XMLChar.isValidNCName(ret)) {
            return ret;
        }
        char[] chars = ret.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (XMLChar.isNCName(c)) continue;
            chars[i] = 95;
        }
        ret = String.valueOf(chars);
        logger.warn("The xml tag name [{}] was escaped to this value [{}]!", (Object)tagName, (Object)ret);
        return ret;
    }
}

