/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.sap.extension.internal.mapping;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.mule.modules.sap.extension.internal.exception.mapping.SapXmlParserException;
import org.mule.modules.sap.extension.internal.mapping.NodeListIterable;
import org.mule.modules.sap.extension.internal.mapping.SapNameEncoder;
import org.mule.modules.sap.extension.internal.mapping.SapXmlTransformer;
import org.mule.modules.sap.extension.internal.mapping.XMLBuilder;
import org.mule.modules.sap.extension.internal.model.document.Component;
import org.mule.modules.sap.extension.internal.model.document.IDocument;
import org.mule.modules.sap.extension.internal.model.document.LeafSegment;
import org.mule.modules.sap.extension.internal.model.document.Segment;
import org.mule.modules.sap.extension.internal.model.metadata.Metadata;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class IDocumentXmlTransformer
implements SapXmlTransformer<IDocument> {
    @Override
    public InputStream toXml(IDocument iDocument, String encoding) {
        try {
            Document xml = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element root = xml.createElement(iDocument.getName());
            Element iDocumentElement = xml.createElement("IDOC");
            iDocumentElement.setAttribute("BEGIN", "1");
            for (Component<?> segment : iDocument.getComponents()) {
                Element segmentElement = xml.createElement(SapNameEncoder.encodeSapObjectName(segment.getName()));
                segment.accept(new XMLBuilder(segmentElement));
                iDocumentElement.appendChild(segmentElement);
            }
            root.appendChild(iDocumentElement);
            xml.appendChild(root);
            return this.toXml(xml);
        }
        catch (ParserConfigurationException | TransformerException e) {
            throw new SapXmlParserException(e);
        }
    }

    @Override
    public InputStream getXmlSchema(Metadata metadata, String encoding) {
        try {
            Document schema = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element root = schema.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:schema");
            root.setAttribute("version", "1.0");
            metadata.appendTo(root);
            schema.appendChild(root);
            return this.toXml(schema);
        }
        catch (ParserConfigurationException | TransformerException e) {
            throw new SapXmlParserException(e);
        }
    }

    @Override
    public IDocument fromXml(InputStream xml, String encoding) {
        try {
            if (xml == null) {
                return null;
            }
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(xml);
            ArrayList components = new ArrayList();
            for (Node child : NodeListIterable.from(document.getElementsByTagName("IDOC").item(0).getChildNodes())) {
                if (child.getNodeType() != 1) continue;
                components.add(this.parse(child.getNodeName(), child));
            }
            return new IDocument(document.getFirstChild().getNodeName(), components);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new SapXmlParserException(e);
        }
    }

    private Component<?> parse(String name, Node node) {
        Component result;
        ArrayList<Node> children = new ArrayList<Node>();
        for (Node child : NodeListIterable.from(node.getChildNodes())) {
            if (child.getNodeType() != 1) continue;
            children.add(child);
        }
        if (children.isEmpty()) {
            result = new LeafSegment(name, node.getTextContent());
        } else {
            ArrayList components = new ArrayList();
            for (Node child : children) {
                components.add(this.parse(child.getNodeName(), child));
            }
            result = new Segment(name, components);
        }
        return result;
    }

    private InputStream toXml(Document document) throws TransformerException {
        StringWriter stringWriter = new StringWriter();
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.transform(new DOMSource(document), new StreamResult(stringWriter));
        return new ByteArrayInputStream(stringWriter.toString().getBytes(Charset.forName("UTF-8")));
    }
}

