/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.sap.extension.internal.mapping;

import java.nio.charset.Charset;
import java.util.List;
import java.util.Optional;
import org.mule.modules.sap.extension.internal.mapping.SapNameEncoder;
import org.mule.modules.sap.extension.internal.model.document.Component;
import org.mule.modules.sap.extension.internal.model.document.ComponentVisitor;
import org.mule.modules.sap.extension.internal.model.document.LeafSegment;
import org.mule.modules.sap.extension.internal.model.document.Segment;
import org.mule.modules.sap.extension.internal.model.function.Field;
import org.mule.modules.sap.extension.internal.model.function.ParameterField;
import org.mule.modules.sap.extension.internal.model.function.ParameterFieldVisitor;
import org.mule.modules.sap.extension.internal.model.function.Structure;
import org.mule.modules.sap.extension.internal.model.function.Table;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLBuilder
implements ParameterFieldVisitor,
ComponentVisitor {
    private final Document document;
    private final Element node;

    public XMLBuilder(Element node) {
        this.document = node.getOwnerDocument();
        this.node = node;
    }

    @Override
    public void visit(Table table) {
        for (Structure row : table.getRows()) {
            Element rowElement = this.document.createElement(Table.ROW_TAG);
            rowElement.setAttribute("id", String.valueOf(this.node.getChildNodes().getLength()));
            for (ParameterField field : row.getFields()) {
                Element fieldElement = this.document.createElement(SapNameEncoder.encodeSapObjectName(field.getName()));
                field.accept(new XMLBuilder(fieldElement));
                rowElement.appendChild(fieldElement);
            }
            this.node.appendChild(rowElement);
        }
    }

    @Override
    public void visit(Structure structure) {
        for (ParameterField field : structure.getFields()) {
            Element fieldElement = this.document.createElement(SapNameEncoder.encodeSapObjectName(field.getName()));
            field.accept(new XMLBuilder(fieldElement));
            this.node.appendChild(fieldElement);
        }
    }

    @Override
    public void visit(Field field) {
        Object value = field.getValue();
        if (value instanceof byte[]) {
            value = new String((byte[])value, Charset.forName("UTF-8"));
        }
        this.node.appendChild(this.document.createTextNode(Optional.ofNullable(value).orElse("").toString()));
    }

    @Override
    public void visit(Segment segment) {
        this.node.setAttribute("SEGMENT", "1");
        for (Component component : (List)segment.getValue()) {
            Element componentElement = this.document.createElement(SapNameEncoder.encodeSapObjectName(component.getName()));
            component.accept(new XMLBuilder(componentElement));
            this.node.appendChild(componentElement);
        }
    }

    @Override
    public void visit(LeafSegment leafSegment) {
        Object value = leafSegment.getValue();
        this.node.appendChild(this.document.createTextNode(Optional.ofNullable(value).orElse("").toString()));
    }
}

