/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.sap.extension.internal.metadata;

import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.xml.api.SchemaCollector;
import org.mule.metadata.xml.api.XmlTypeLoader;
import org.mule.modules.sap.extension.internal.config.SapOutboundConfig;
import org.mule.modules.sap.extension.internal.connection.SapConnection;
import org.mule.modules.sap.extension.internal.exception.connection.MissingConnectionException;
import org.mule.modules.sap.extension.internal.mapping.SapXmlTransformer;
import org.mule.modules.sap.extension.internal.model.BusinessObject;
import org.mule.modules.sap.extension.internal.service.BusinessObjectService;
import org.mule.modules.sap.extension.internal.service.ServiceCreationStrategy;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeyBuilder;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.InputTypeResolver;
import org.mule.runtime.api.metadata.resolving.OutputTypeResolver;
import org.mule.runtime.api.metadata.resolving.TypeKeysResolver;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;

public abstract class BusinessObjectMetadataResolver<BO extends BusinessObject>
implements InputTypeResolver<String>,
TypeKeysResolver,
OutputTypeResolver<String> {
    private final LazyValue<SapXmlTransformer<BO>> transformer;
    private final LazyValue<ServiceCreationStrategy<BO>> creationStrategy;

    public BusinessObjectMetadataResolver(LazyValue<SapXmlTransformer<BO>> transformer, Supplier<ServiceCreationStrategy<BO>> creationStrategy) {
        this.transformer = transformer;
        this.creationStrategy = new LazyValue(creationStrategy);
    }

    public String getResolverName() {
        return this.getClass().getSimpleName();
    }

    public MetadataType getInputMetadata(MetadataContext metadataContext, String key) throws MetadataResolvingException, ConnectionException {
        return this.getMetadataType(metadataContext, key);
    }

    public MetadataType getOutputType(MetadataContext metadataContext, String key) throws MetadataResolvingException, ConnectionException {
        return this.getMetadataType(metadataContext, key);
    }

    private MetadataType getMetadataType(MetadataContext metadataContext, String key) throws MetadataResolvingException, ConnectionException {
        SapOutboundConfig config = this.getConfig(metadataContext);
        SchemaCollector schemas = SchemaCollector.getInstance();
        schemas.addSchema(key, ((SapXmlTransformer)this.transformer.get()).getXmlSchema(this.getService(metadataContext).getMetadata(key, config.getEncoding(), null), config.getEncoding()));
        return (MetadataType)new XmlTypeLoader(schemas).load(this.escapeSlash(key)).get();
    }

    private String escapeSlash(String metadataKey) {
        return metadataKey.replaceAll("/", "_-");
    }

    public Set<MetadataKey> getKeys(MetadataContext metadataContext) throws MetadataResolvingException, ConnectionException {
        return this.getService(metadataContext).getKeys().entrySet().stream().map(entry -> MetadataKeyBuilder.newKey((String)((String)entry.getKey())).withDisplayName((String)entry.getValue())).map(MetadataKeyBuilder::build).collect(Collectors.toSet());
    }

    public String getCategoryName() {
        return this.getClass().getSimpleName();
    }

    private SapOutboundConfig getConfig(MetadataContext context) {
        Object config = context.getConfig().get();
        return config instanceof SapOutboundConfig ? (SapOutboundConfig)config : (SapOutboundConfig)((ConfigurationInstance)((Optional)context.getConfig().get()).get()).getValue();
    }

    private BusinessObjectService<BO> getService(MetadataContext metadataContext) throws MetadataResolvingException, ConnectionException {
        return ((ServiceCreationStrategy)this.creationStrategy.get()).create((SapConnection)metadataContext.getConnection().orElseThrow(MissingConnectionException::new), this.getConfig(metadataContext));
    }
}

