/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.sap.extension.internal.model.document;

import java.io.Serializable;
import java.util.Optional;

public class IDocId
implements Serializable {
    private static final long serialVersionUID = 8735109876940928542L;
    private String iDocType;
    private String iDocExtendedType;
    private String systemRelease;
    private String applicationRelease;
    private static final String TOKEN = "-";

    public IDocId() {
    }

    public IDocId(String iDocId) {
        if (Optional.ofNullable(iDocId).filter(value -> !value.isEmpty()).isPresent()) {
            String[] elements = this.splitIDocId(iDocId);
            this.setIDocType(elements.length > 0 ? elements[0] : null);
            this.setIDocExtendedType(elements.length > 1 ? elements[1] : null);
            this.setSystemRelease(elements.length > 2 ? elements[2] : null);
            this.setApplicationRelease(elements.length > 3 ? elements[3] : null);
        }
    }

    private String[] splitIDocId(String iDocId) {
        if (iDocId != null) {
            int tokenIndex;
            String[] elements = new String[4];
            int i = 0;
            int from = 0;
            do {
                if ((tokenIndex = iDocId.indexOf(TOKEN, from)) == 0 || tokenIndex == iDocId.length() - 1 || i > 3) {
                    throw new IllegalArgumentException("Invalid iDoc ID '" + iDocId + "'. Valid IDs are of the form 'IDOC_TYPE' or 'IDOC_TYPE-EXTENDED_TYPE-SYSTEM_RELEASE-APPLICATION_RELEASE'");
                }
                if (tokenIndex < 0) {
                    elements[i++] = iDocId.substring(from);
                    break;
                }
                elements[i++] = from == tokenIndex ? null : iDocId.substring(from, tokenIndex);
                from = tokenIndex + 1;
            } while (tokenIndex >= 0);
            for (int j = i; j < elements.length; ++j) {
                elements[j] = null;
            }
            return elements;
        }
        return new String[0];
    }

    public String getIDocId() {
        if (this.isNotBlank(this.getIDocType())) {
            StringBuilder id = new StringBuilder();
            id.append(this.getIDocType());
            if (this.isNotBlank(this.getIDocExtendedType()) || this.isNotBlank(this.getSystemRelease()) || this.isNotBlank(this.getApplicationRelease())) {
                id.append(TOKEN);
                id.append(this.isNotBlank(this.getIDocExtendedType()) ? this.getIDocExtendedType() : "");
            }
            if (this.isNotBlank(this.getSystemRelease()) || this.isNotBlank(this.getApplicationRelease())) {
                id.append(TOKEN);
                id.append(this.isNotBlank(this.getSystemRelease()) ? this.getSystemRelease() : "");
            }
            if (this.isNotBlank(this.getApplicationRelease())) {
                id.append(TOKEN);
                id.append(this.getApplicationRelease());
            }
            return id.toString();
        }
        return null;
    }

    private boolean isNotBlank(String value) {
        return Optional.ofNullable(value).map(String::trim).map(String::isEmpty).map(v -> v == false).orElse(false);
    }

    public String getIDocType() {
        return this.iDocType;
    }

    public String getIDocExtendedType() {
        return this.iDocExtendedType;
    }

    public boolean isExtendedType() {
        return !Optional.ofNullable(this.getIDocExtendedType()).orElse("").isEmpty();
    }

    public String getSystemRelease() {
        return this.systemRelease;
    }

    public String getApplicationRelease() {
        return this.applicationRelease;
    }

    public void setIDocType(String iDocType) {
        this.iDocType = iDocType;
    }

    public void setIDocExtendedType(String iDocExtendedType) {
        this.iDocExtendedType = iDocExtendedType;
    }

    public void setSystemRelease(String systemRelease) {
        this.systemRelease = systemRelease;
    }

    public void setApplicationRelease(String applicationRelease) {
        this.applicationRelease = applicationRelease;
    }

    public String toString() {
        return this.isExtendedType() ? this.getIDocExtendedType() : this.getIDocType();
    }
}

