/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.sap.extension.internal.model.metadata;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.mule.modules.sap.extension.internal.mapping.SapNameEncoder;
import org.mule.modules.sap.extension.internal.model.metadata.Metadata;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FunctionComposedMetadata
extends Metadata {
    private boolean sorted;
    private List<Metadata> components = new ArrayList<Metadata>();

    public FunctionComposedMetadata(String name, String description) {
        this(name, description, false);
    }

    public FunctionComposedMetadata(String name, String description, boolean sorted) {
        super(name, description);
        this.sorted = sorted;
    }

    @Override
    public void appendTo(Element parent) {
        Document document = parent.getOwnerDocument();
        Element node = document.createElement("xsd:element");
        node.setAttribute("name", SapNameEncoder.encodeSapObjectName(this.getName()));
        if (!parent.getNodeName().equals("xsd:schema")) {
            node.setAttribute("minOccurs", "0");
            node.setAttribute("maxOccurs", this.getName().equals("row") ? "unbounded" : "1");
        }
        if (Optional.ofNullable(this.getDescription()).map(String::trim).filter(value -> !value.isEmpty()).isPresent()) {
            Element annotation = document.createElement("xsd:annotation");
            Element documentation = document.createElement("xsd:documentation");
            documentation.appendChild(document.createTextNode(this.getDescription()));
            annotation.appendChild(documentation);
            node.appendChild(annotation);
        }
        Element complexElement = document.createElement("xsd:complexType");
        Element sortElement = document.createElement(this.sorted ? "xsd:sequence" : "xsd:all");
        for (Metadata component : this.components) {
            if (component.getName().isEmpty()) continue;
            component.appendTo(sortElement);
        }
        complexElement.appendChild(sortElement);
        node.appendChild(complexElement);
        for (String attribute : this.getAttributes()) {
            Element attributeElement = document.createElement("xsd:attribute");
            attributeElement.setAttribute("name", attribute);
            attributeElement.setAttribute("type", "xsd:string");
            complexElement.appendChild(attributeElement);
        }
        if (this.sorted) {
            complexElement.appendChild(this.createAttribute(document, "timestamp"));
            complexElement.appendChild(this.createAttribute(document, "version"));
        } else {
            complexElement.appendChild(this.createAttribute(document, "type"));
        }
        parent.appendChild(node);
    }

    private Element createAttribute(Document document, String name) {
        Element attribute = document.createElement("xsd:attribute");
        attribute.setAttribute("name", name);
        attribute.setAttribute("type", "xsd:string");
        return attribute;
    }

    public void addComponent(Metadata metadata) {
        this.components.add(metadata);
    }

    public List<Metadata> getComponents() {
        return this.components;
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public void setComponents(List<Metadata> components) {
        this.components = components;
    }

    public void setSorted(boolean sorted) {
        this.sorted = sorted;
    }
}

