/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.sap.extension.internal.model.metadata;

import java.util.Optional;
import org.mule.modules.sap.extension.internal.mapping.SapNameEncoder;
import org.mule.modules.sap.extension.internal.model.metadata.Metadata;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FunctionFieldMetadata
extends Metadata {
    public FunctionFieldMetadata(String name, String description) {
        super(name, description);
    }

    @Override
    public void appendTo(Element parent) {
        Document document = parent.getOwnerDocument();
        Element node = document.createElement("xsd:element");
        node.setAttribute("name", SapNameEncoder.encodeSapObjectName(this.getName()));
        node.setAttribute("minOccurs", "0");
        node.setAttribute("maxOccurs", "1");
        if (Optional.ofNullable(this.getDescription()).map(String::trim).filter(value -> !value.isEmpty()).isPresent()) {
            Element annotation = document.createElement("xsd:annotation");
            Element documentation = document.createElement("xsd:documentation");
            documentation.appendChild(document.createTextNode(this.getDescription()));
            annotation.appendChild(documentation);
            node.appendChild(annotation);
        }
        Element complexType = document.createElement("xsd:complexType");
        Element simpleType = document.createElement("xsd:simpleContent");
        Element extension = document.createElement("xsd:extension");
        extension.setAttribute("base", "xsd:string");
        for (String attribute : this.getAttributes()) {
            complexType.appendChild(this.createAttribute(document, attribute));
        }
        extension.appendChild(this.createAttribute(document, "type"));
        extension.appendChild(this.createAttribute(document, "optional"));
        extension.appendChild(this.createAttribute(document, "description"));
        extension.appendChild(this.createAttribute(document, "dataType"));
        extension.appendChild(this.createAttribute(document, "length"));
        extension.appendChild(this.createAttribute(document, "trim"));
        simpleType.appendChild(extension);
        complexType.appendChild(simpleType);
        node.appendChild(complexType);
        parent.appendChild(node);
    }

    private Element createAttribute(Document document, String name) {
        Element attribute = document.createElement("xsd:attribute");
        attribute.setAttribute("name", name);
        attribute.setAttribute("type", "xsd:string");
        return attribute;
    }
}

