/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.sap.extension.internal.model.metadata;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.mule.modules.sap.extension.internal.mapping.SapNameEncoder;
import org.mule.modules.sap.extension.internal.model.metadata.Metadata;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class IDocumentComposedMetadata
extends Metadata {
    private final Long minOccurrence;
    private final Long maxOccurrence;
    private List<Metadata> components = new ArrayList<Metadata>();

    public IDocumentComposedMetadata(String name, String description, Long minOccurrence, Long maxOccurrence) {
        super(name, description);
        this.minOccurrence = minOccurrence;
        this.maxOccurrence = maxOccurrence;
    }

    @Override
    public void appendTo(Element parent) {
        Document document = parent.getOwnerDocument();
        Element node = document.createElement("xsd:element");
        node.setAttribute("name", SapNameEncoder.encodeSapObjectName(this.getName()));
        if (this.minOccurrence > 0L || this.maxOccurrence > 0L) {
            node.setAttribute("minOccurs", String.valueOf(this.minOccurrence));
            node.setAttribute("maxOccurs", this.maxOccurrence > 5000L ? "unbounded" : String.valueOf(this.maxOccurrence));
        }
        if (Optional.ofNullable(this.getDescription()).map(String::trim).filter(value -> !value.isEmpty()).isPresent()) {
            Element annotation = document.createElement("xsd:annotation");
            Element documentation = document.createElement("xsd:documentation");
            documentation.appendChild(document.createTextNode(this.getDescription()));
            annotation.appendChild(documentation);
            node.appendChild(annotation);
        }
        Element complexElement = document.createElement("xsd:complexType");
        Element sortElement = document.createElement("xsd:sequence");
        for (Metadata component : this.components) {
            component.appendTo(sortElement);
        }
        complexElement.appendChild(sortElement);
        node.appendChild(complexElement);
        for (String attribute : this.getAttributes()) {
            Element attributeElement = document.createElement("xsd:attribute");
            attributeElement.setAttribute("name", attribute);
            Element simpleType = document.createElement("xsd:simpleType");
            Element restriction = document.createElement("xsd:restriction");
            restriction.setAttribute("base", "xsd:string");
            Element enumeration = document.createElement("xsd:enumeration");
            enumeration.setAttribute("value", "1");
            restriction.appendChild(enumeration);
            simpleType.appendChild(restriction);
            attributeElement.appendChild(simpleType);
            complexElement.appendChild(attributeElement);
        }
        if (this.getName().equals("IDOC")) {
            Element attribute = document.createElement("xsd:attribute");
            attribute.setAttribute("name", "BEGIN");
            attribute.setAttribute("use", "required");
            Element simpleType = document.createElement("xsd:simpleType");
            Element restriction = document.createElement("xsd:restriction");
            restriction.setAttribute("base", "xsd:string");
            Element enumeration = document.createElement("xsd:enumeration");
            enumeration.setAttribute("value", "1");
            restriction.appendChild(enumeration);
            simpleType.appendChild(restriction);
            attribute.appendChild(simpleType);
            complexElement.appendChild(attribute);
        }
        parent.appendChild(node);
    }

    public void addComponent(Metadata metadata) {
        this.components.add(metadata);
    }

    public List<Metadata> getComponents() {
        return this.components;
    }

    public void setComponents(List<Metadata> components) {
        this.components = components;
    }
}

