/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.sap.extension.internal.model.metadata;

import java.util.Optional;
import org.mule.modules.sap.extension.internal.mapping.SapNameEncoder;
import org.mule.modules.sap.extension.internal.model.metadata.Metadata;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class IDocumentFieldMetadata
extends Metadata {
    private Integer limit;

    public IDocumentFieldMetadata(String name, String description, Integer limit) {
        super(name, description);
        this.limit = limit;
    }

    @Override
    public void appendTo(Element parent) {
        Document document = parent.getOwnerDocument();
        Element node = document.createElement("xsd:element");
        node.setAttribute("name", SapNameEncoder.encodeSapObjectName(this.getName()));
        if (Optional.ofNullable(this.getDescription()).map(String::trim).filter(value -> !value.isEmpty()).isPresent()) {
            Element annotation = document.createElement("xsd:annotation");
            Element documentation = document.createElement("xsd:documentation");
            documentation.appendChild(document.createTextNode(this.getDescription()));
            annotation.appendChild(documentation);
            node.appendChild(annotation);
        }
        Element simpleType = document.createElement("xsd:simpleType");
        if (this.limit != null) {
            Element restriction = document.createElement("xsd:restriction");
            Element maxLength = document.createElement("xsd:maxLength");
            maxLength.setAttribute("value", String.valueOf(this.limit));
            restriction.appendChild(maxLength);
            restriction.setAttribute("base", "xsd:string");
            simpleType.appendChild(restriction);
        }
        node.appendChild(simpleType);
        parent.appendChild(node);
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }
}

