/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.sap.extension.internal.operation;

import java.io.InputStream;
import org.mule.modules.sap.extension.internal.config.SapOutboundConfig;
import org.mule.modules.sap.extension.internal.connection.SapConnection;
import org.mule.modules.sap.extension.internal.error.SapErrorTypeProvider;
import org.mule.modules.sap.extension.internal.metadata.BAPIFunctionMetadataResolver;
import org.mule.modules.sap.extension.internal.model.BusinessObject;
import org.mule.modules.sap.extension.internal.model.function.BAPIFunction;
import org.mule.modules.sap.extension.internal.operation.BusinessObjectOperations;
import org.mule.modules.sap.extension.internal.service.BusinessObjectService;
import org.mule.modules.sap.extension.internal.service.SapServiceFactory;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BAPIFunctionOperations
extends BusinessObjectOperations<BAPIFunction> {
    private static final Logger logger = LoggerFactory.getLogger(BAPIFunctionOperations.class);

    public BAPIFunctionOperations() {
        super(SapServiceFactory.getInstance()::createBAPIFunctionService, SapServiceFactory.getInstance().createBAPIFunctionStaxParser());
    }

    @OutputResolver(output=BAPIFunctionMetadataResolver.class)
    @Throws(value={SapErrorTypeProvider.class})
    @MediaType(value="application/xml")
    public InputStream getFunction(@Connection SapConnection connection, @Config SapOutboundConfig config, @MetadataKeyId(value=BAPIFunctionMetadataResolver.class) @Summary(value="The name of the function to retrieve") String key) {
        logger.info("Retrieving function with name '{}'.", (Object)key);
        return this.toXmlResult((BusinessObject)this.newExecutionBuilder(config, connection).execute(BusinessObjectService::get).withParam((Object)key), config);
    }

    @DisplayName(value="Execute BAPI / Function over sRFC")
    @OutputResolver(output=BAPIFunctionMetadataResolver.class)
    @Throws(value={SapErrorTypeProvider.class})
    @MediaType(value="application/xml")
    public InputStream executeSynchronousRemoteFunctionCall(@Connection SapConnection connection, @Config SapOutboundConfig config, @MetadataKeyId(value=BAPIFunctionMetadataResolver.class) @Summary(value="The name of the function to execute") String key, @Content @TypeResolver(value=BAPIFunctionMetadataResolver.class) InputStream content) {
        logger.info("Executing sRFC over function '{}'.", (Object)key);
        if (logger.isDebugEnabled()) {
            logger.debug("Function content is:\n{}", (Object)content);
        }
        return this.toXmlResult((BusinessObject)this.newExecutionBuilder(config, connection).execute(BusinessObjectService::executeSynchronousRFC).withParam(this.fromXml(content, config)), config);
    }

    @DisplayName(value="Execute BAPI / Function over tRFC")
    @OutputResolver(output=BAPIFunctionMetadataResolver.class)
    @Throws(value={SapErrorTypeProvider.class})
    public void executeTransactionalRemoteFunctionCall(@Connection SapConnection connection, @Config SapOutboundConfig config, @MetadataKeyId(value=BAPIFunctionMetadataResolver.class) @Summary(value="The name of the function to execute") String key, @Content @TypeResolver(value=BAPIFunctionMetadataResolver.class) InputStream content, @Optional @Summary(value="The ID that identifies an RFC so it's run only once") String transactionId) {
        logger.info("Executing tRFC over function '{}'.", (Object)key);
        if (logger.isDebugEnabled()) {
            logger.debug("Function content is:\n{}", (Object)content);
        }
        this.newExecutionBuilder(config, connection).execute(BusinessObjectService::executeTransactionalRFC).withParam(this.fromXml(content, config)).withParam((Object)transactionId);
    }

    @DisplayName(value="Execute BAPI / Function over qRFC")
    @OutputResolver(output=BAPIFunctionMetadataResolver.class)
    @Throws(value={SapErrorTypeProvider.class})
    public void executeQueuedRemoteFunctionCall(@Connection SapConnection connection, @Config SapOutboundConfig config, @MetadataKeyId(value=BAPIFunctionMetadataResolver.class) @Summary(value="The name of the function to execute") String key, @Content @TypeResolver(value=BAPIFunctionMetadataResolver.class) InputStream content, @Optional @Summary(value="The ID that identifies an RFC so it's run only once") String transactionId, @Summary(value="The name of the queue where the transaction will be run") String queueName) {
        logger.info("Executing qRFC over function '{}'.", (Object)key);
        if (logger.isDebugEnabled()) {
            logger.debug("Function content is:\n{}", (Object)content);
        }
        this.newExecutionBuilder(config, connection).execute(BusinessObjectService::executeQueuedRFC).withParam(this.fromXml(content, config)).withParam((Object)transactionId).withParam((Object)queueName);
    }
}

