/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.sap.extension.internal.operation;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.mule.connectors.atlantic.commons.builder.execution.ExecutionBuilder;
import org.mule.connectors.atlantic.commons.builder.lambda.function.BiFunction;
import org.mule.connectors.commons.template.config.ConnectorConfig;
import org.mule.connectors.commons.template.connection.ConnectorConnection;
import org.mule.connectors.commons.template.operation.ConnectorOperations;
import org.mule.modules.sap.extension.internal.config.SapOutboundConfig;
import org.mule.modules.sap.extension.internal.connection.SapConnection;
import org.mule.modules.sap.extension.internal.error.APIErrorCode;
import org.mule.modules.sap.extension.internal.exception.SapInternalException;
import org.mule.modules.sap.extension.internal.exception.mapping.SapXmlParserException;
import org.mule.modules.sap.extension.internal.mapping.NodeListIterable;
import org.mule.modules.sap.extension.internal.mapping.SapXmlTransformer;
import org.mule.modules.sap.extension.internal.model.BusinessObject;
import org.mule.modules.sap.extension.internal.model.document.Component;
import org.mule.modules.sap.extension.internal.model.document.IDocument;
import org.mule.modules.sap.extension.internal.model.document.LeafSegment;
import org.mule.modules.sap.extension.internal.model.document.Segment;
import org.mule.modules.sap.extension.internal.service.BusinessObjectService;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class BusinessObjectOperations<BO extends BusinessObject>
extends ConnectorOperations<SapOutboundConfig, SapConnection, BusinessObjectService<BO>> {
    private final SapXmlTransformer<BO> transformer;

    public BusinessObjectOperations(BiFunction<SapOutboundConfig, SapConnection, BusinessObjectService<BO>> serviceConstructor, SapXmlTransformer<BO> transformer) {
        super(serviceConstructor);
        this.transformer = transformer;
    }

    protected InputStream toXmlResult(BO businessObject, SapOutboundConfig config) {
        return this.transformer.toXml(businessObject, config.getEncoding());
    }

    protected BO fromXml(InputStream function, SapOutboundConfig config) {
        return this.transformer.fromXml(function, config.getEncoding());
    }

    protected List<IDocument> fromXmlToListOfIdoc(InputStream idoc) {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(idoc);
            ArrayList<IDocument> iDocumentList = new ArrayList<IDocument>();
            if (this.containsMultipleIdocs(document.getElementsByTagName("IDOC"))) {
                int index = 0;
                while (document.getElementsByTagName("IDOC").item(index) != null) {
                    iDocumentList.add(new IDocument(document.getFirstChild().getNodeName(), this.getForIndexIdocComponentsAsList(document, index)));
                    ++index;
                }
                return iDocumentList;
            }
            iDocumentList.add(new IDocument(document.getFirstChild().getNodeName(), this.getForIndexIdocComponentsAsList(document, 0)));
            return iDocumentList;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new SapXmlParserException(e);
        }
    }

    private boolean containsMultipleIdocs(NodeList idoc) {
        return idoc.item(1) != null;
    }

    private List<Component<?>> getForIndexIdocComponentsAsList(Document document, int index) {
        ArrayList components = new ArrayList();
        for (Node child : NodeListIterable.from(document.getElementsByTagName("IDOC").item(index).getChildNodes())) {
            if (child.getNodeType() != 1) continue;
            components.add(this.parse(child.getNodeName(), child));
        }
        return components;
    }

    private Component<?> parse(String name, Node node) {
        Component result;
        ArrayList<Node> children = new ArrayList<Node>();
        for (Node child : NodeListIterable.from(node.getChildNodes())) {
            if (child.getNodeType() != 1) continue;
            children.add(child);
        }
        if (children.isEmpty()) {
            result = new LeafSegment(name, node.getTextContent());
        } else {
            ArrayList components = new ArrayList();
            for (Node child : children) {
                components.add(this.parse(child.getNodeName(), child));
            }
            result = new Segment(name, components);
        }
        return result;
    }

    protected ExecutionBuilder<BusinessObjectService<BO>> newExecutionBuilder(SapOutboundConfig config, SapConnection connection) {
        return (ExecutionBuilder)((ExecutionBuilder)super.newExecutionBuilder((ConnectorConfig)config, (ConnectorConnection)connection).withExceptionHandler(Exception.class, exception -> {
            throw new ModuleException((ErrorTypeDefinition)APIErrorCode.UNKNOWN, exception);
        })).withExceptionHandler(SapInternalException.class, exception -> {
            throw exception;
        });
    }
}

