/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.sap.extension.internal.operation;

import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import org.mule.modules.sap.extension.internal.config.SapOutboundConfig;
import org.mule.modules.sap.extension.internal.connection.SapConnection;
import org.mule.modules.sap.extension.internal.error.SapErrorTypeProvider;
import org.mule.modules.sap.extension.internal.exception.SapExceptionEnricher;
import org.mule.modules.sap.extension.internal.metadata.IDocumentMetadataResolver;
import org.mule.modules.sap.extension.internal.model.BusinessObject;
import org.mule.modules.sap.extension.internal.model.document.IDocument;
import org.mule.modules.sap.extension.internal.operation.BusinessObjectOperations;
import org.mule.modules.sap.extension.internal.service.BusinessObjectService;
import org.mule.modules.sap.extension.internal.service.SapServiceFactory;
import org.mule.runtime.extension.api.annotation.OnException;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@OnException(value=SapExceptionEnricher.class)
public class IDocumentOperations
extends BusinessObjectOperations<IDocument> {
    private static final Logger logger = LoggerFactory.getLogger(IDocumentOperations.class);

    public IDocumentOperations() {
        super(SapServiceFactory.getInstance()::createIDocumentService, SapServiceFactory.getInstance().createIDocumentParser());
    }

    @DisplayName(value="Create IDoc")
    @OutputResolver(output=IDocumentMetadataResolver.class)
    @Throws(value={SapErrorTypeProvider.class})
    @MediaType(value="application/xml")
    public InputStream createIdoc(@Connection SapConnection connection, @Config SapOutboundConfig config, @MetadataKeyId(value=IDocumentMetadataResolver.class) String key) {
        return this.toXmlResult((BusinessObject)this.newExecutionBuilder(config, connection).execute(BusinessObjectService::get).withParam((Object)key), config);
    }

    @DisplayName(value="Send IDoc")
    @Throws(value={SapErrorTypeProvider.class})
    public void send(@Connection SapConnection connection, @Config SapOutboundConfig config, @MetadataKeyId(value=IDocumentMetadataResolver.class) @Summary(value="The name of the function to execute") String key, @Content @TypeResolver(value=IDocumentMetadataResolver.class) InputStream content, @org.mule.runtime.extension.api.annotation.param.Optional @Summary(value="The version of the IDoc") Character version, @org.mule.runtime.extension.api.annotation.param.Optional @Summary(value="The ID that identifies an RFC so it's run only once") String transactionId, @org.mule.runtime.extension.api.annotation.param.Optional @Summary(value="The name of the queue where the transaction will be run") String queueName) {
        List<IDocument> iDocuments = this.fromXmlToListOfIdoc(content);
        iDocuments.forEach(iDocument -> iDocument.setIDocVersion(Character.valueOf(Optional.ofNullable(version).map(Object::toString).orElseGet(config.getAdvancedConfig()::getDefaultIDocumentVersion).charAt(0))));
        logger.info("Executing {} over iDocument '{}'.", (Object)Optional.ofNullable(queueName).map(name -> "qRFC").orElse("tRFC"), (Object)key);
        if (logger.isDebugEnabled()) {
            logger.debug("iDocument content is:\n{}", (Object)content);
        }
        if (iDocuments.size() == 1) {
            if (queueName == null) {
                this.newExecutionBuilder(config, connection).execute(BusinessObjectService::executeTransactionalRFC).withParam((Object)iDocuments.get(0)).withParam((Object)transactionId);
            } else {
                this.newExecutionBuilder(config, connection).execute(BusinessObjectService::executeQueuedRFC).withParam((Object)iDocuments.get(0)).withParam((Object)transactionId).withParam((Object)queueName);
            }
        } else if (iDocuments.size() > 1 && queueName != null) {
            this.newExecutionBuilder(config, connection).execute(BusinessObjectService::executeQueuedRFCIdocCollection).withParam(iDocuments).withParam((Object)transactionId).withParam((Object)queueName);
        } else {
            this.newExecutionBuilder(config, connection).execute(BusinessObjectService::executeTransactionalRFCFIdocCollection).withParam(iDocuments).withParam((Object)transactionId).withParam((Object)queueName);
        }
    }
}

