/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.sap.extension.internal.operation;

import org.mule.connectors.commons.template.operation.ConnectorOperations;
import org.mule.modules.sap.extension.internal.config.SapConfig;
import org.mule.modules.sap.extension.internal.connection.SapConnection;
import org.mule.modules.sap.extension.internal.service.SapServiceFactory;
import org.mule.modules.sap.extension.internal.service.TransactionService;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionOperations
extends ConnectorOperations<SapConfig, SapConnection, TransactionService> {
    private static final Logger logger = LoggerFactory.getLogger(TransactionOperations.class);

    public TransactionOperations() {
        super(SapServiceFactory.getInstance()::createTransactionService);
    }

    @MediaType(value="application/plain")
    public String createTransactionId(@Config SapConfig config, @Connection SapConnection connection) {
        logger.info("Creating transaction ID.");
        return (String)this.newExecutionBuilder(config, connection).execute(TransactionService::createTransactionId);
    }

    public void confirmTransactionId(@Config SapConfig config, @Connection SapConnection connection, String transactionId) {
        logger.info("Confirming transaction ID '{}'.", (Object)transactionId);
        this.newExecutionBuilder(config, connection).execute(TransactionService::confirm).withParam((Object)transactionId);
    }
}

