/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.sap.extension.internal.service;

import com.sap.conn.jco.AbapException;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoField;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoParameterList;
import com.sap.conn.jco.JCoRecord;
import com.sap.conn.jco.JCoStructure;
import com.sap.conn.jco.JCoTable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.mule.modules.sap.extension.internal.config.SapOutboundConfig;
import org.mule.modules.sap.extension.internal.connection.SapConnection;
import org.mule.modules.sap.extension.internal.exception.business.BusinessObjectExecutionException;
import org.mule.modules.sap.extension.internal.exception.business.FieldNotFoundException;
import org.mule.modules.sap.extension.internal.exception.business.MissingBusinessObjectException;
import org.mule.modules.sap.extension.internal.exception.business.SearchExecutionException;
import org.mule.modules.sap.extension.internal.model.function.BAPIFunction;
import org.mule.modules.sap.extension.internal.model.function.Field;
import org.mule.modules.sap.extension.internal.model.function.ParameterField;
import org.mule.modules.sap.extension.internal.model.function.Structure;
import org.mule.modules.sap.extension.internal.model.function.Table;
import org.mule.modules.sap.extension.internal.model.metadata.FunctionComposedMetadata;
import org.mule.modules.sap.extension.internal.model.metadata.FunctionFieldMetadata;
import org.mule.modules.sap.extension.internal.model.metadata.Metadata;
import org.mule.modules.sap.extension.internal.service.BusinessObjectJCoService;
import org.mule.modules.sap.extension.internal.service.IdocCollectionSender;
import org.mule.modules.sap.extension.internal.service.JCoFunctionDAO;
import org.mule.modules.sap.extension.internal.service.JCoToBusinessObjectParser;
import org.mule.modules.sap.extension.internal.service.RemoteFunctionCall;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BAPIFunctionJCoService
extends BusinessObjectJCoService<BAPIFunction, JCoFunction> {
    private static final Logger logger = LoggerFactory.getLogger(BAPIFunctionJCoService.class);
    private final JCoFunctionDAO jCoFunctionDAO;
    private final JCoToBusinessObjectParser parser;
    private final boolean evaluateResponseFlag;

    public BAPIFunctionJCoService(SapConnection connection, SapOutboundConfig config) {
        super(connection, config);
        this.evaluateResponseFlag = config.getAdvancedConfig().getEvaluateResponseFlag();
        this.jCoFunctionDAO = new JCoFunctionDAO(this.getDestination(), config.getAdvancedConfig().getDisableFunctionTemplateCacheFlag());
        logger.info("Use SAP default format '{}'.", (Object)config.getAdvancedConfig().getUseSAPFormat());
        this.parser = new JCoToBusinessObjectParser(config.getAdvancedConfig().getUseSAPFormat());
    }

    @Override
    public BAPIFunction get(String functionName) {
        return this.parser.parse(this.jCoFunctionDAO.getFunction(functionName));
    }

    @Override
    public BAPIFunction executeSynchronousRFC(BAPIFunction bapiFunction) {
        return this.doCall(bapiFunction, (String)null, (JCoFunction jCoFunction, String usedTransactionId) -> this.jCoFunctionDAO.executeSynchronousRFC((JCoFunction)jCoFunction));
    }

    @Override
    public void executeQueuedRFCIdocCollection(List<BAPIFunction> businessObject, String transactionId, String queueName) {
        throw new UnsupportedOperationException("Executing queued rfc for list of BAPI functions not supported");
    }

    @Override
    public void executeTransactionalRFCFIdocCollection(List<BAPIFunction> businessObject, String transactionId, String queueName) {
        throw new UnsupportedOperationException("Executing queued rfc for list of BAPI functions not supported");
    }

    @Override
    public void executeTransactionalRFC(BAPIFunction bapiFunction, String transactionId) {
        this.doAsynchronousCall(bapiFunction, transactionId, (J jCoFunction, String usedTransactionId) -> this.jCoFunctionDAO.executeTransactionalRFC((JCoFunction)jCoFunction, usedTransactionId));
    }

    @Override
    public void executeQueuedRFC(BAPIFunction bapiFunction, String transactionId, String queueName) {
        this.doAsynchronousCall(bapiFunction, transactionId, (J jCoFunction, String usedTransactionId) -> this.jCoFunctionDAO.executeQueuedRFC((JCoFunction)jCoFunction, usedTransactionId, queueName));
    }

    @Override
    public BAPIFunction doCall(BAPIFunction bapiFunction, String transactionId, RemoteFunctionCall<JCoFunction> call) {
        try {
            JCoFunction function = this.jCoFunctionDAO.getFunction(bapiFunction.getFunctionName());
            this.parser.parse(function, bapiFunction);
            call.execute(function, transactionId);
            logger.debug("Function [{}] executed successfully.", (Object)function.getName());
            BAPIFunction result = this.parser.parse(function);
            return this.parseFunctionContainingReturnTag(function, result);
        }
        catch (JCoException e) {
            if (e.getKey().equals("NO_FUNCTION_FOUND")) {
                throw new MissingBusinessObjectException(e);
            }
            throw new BusinessObjectExecutionException(e);
        }
    }

    private BAPIFunction parseFunctionContainingReturnTag(JCoFunction function, BAPIFunction result) {
        Predicate<ParameterField> returnFilter = field -> "RETURN".equals(field.getName());
        List parameterList = Optional.ofNullable(result.getExportParameters()).filter(list -> list.stream().anyMatch(returnFilter)).orElseGet(ArrayList::new);
        if (!parameterList.isEmpty()) {
            ParameterField returnField = parameterList.stream().filter(returnFilter).findFirst().get();
            if (returnField instanceof Structure) {
                this.evaluateFunctionResponse(function.getName(), (JCoRecord)function.getExportParameterList().getStructure("RETURN"));
            }
            if (returnField instanceof Table) {
                JCoTable table = function.getExportParameterList().getTable("RETURN");
                for (int i = 0; i < table.getNumRows(); ++i) {
                    table.setRow(i);
                    logger.debug("Evaluating row {} of RESULT table", (Object)i);
                    this.evaluateFunctionResponse(function.getName(), (JCoRecord)table);
                }
            }
        }
        return result;
    }

    @Override
    protected BAPIFunction doCallList(List<BAPIFunction> businessObject, String transactionId, IdocCollectionSender<BAPIFunction> call) {
        throw new UnsupportedOperationException("Calling multiple bapi functions not supported");
    }

    @Override
    public Metadata getMetadata(String operationName, String encoding, Character idocVersion) {
        JCoFunction jCoFunction = this.jCoFunctionDAO.getFunction(operationName);
        FunctionComposedMetadata metadata = new FunctionComposedMetadata(jCoFunction.getName(), "", true);
        metadata.addComponent(this.getMetadata("import", "Import Parameter List", jCoFunction.getImportParameterList()));
        metadata.addComponent(this.getMetadata("export", "Export Parameter List", jCoFunction.getExportParameterList()));
        metadata.addComponent(this.getMetadata("changing", "Changing Parameter List", jCoFunction.getChangingParameterList()));
        metadata.addComponent(this.getMetadata("tables", "Table Parameter List", jCoFunction.getTableParameterList()));
        FunctionComposedMetadata errors = new FunctionComposedMetadata("errors", "Possible Error List");
        for (AbapException abapException : Optional.ofNullable(jCoFunction.getExceptionList()).orElse(new AbapException[0])) {
            errors.addComponent(new FunctionFieldMetadata(abapException.getKey(), abapException.getLocalizedMessage()));
        }
        metadata.addComponent(errors);
        return metadata;
    }

    private Metadata getMetadata(String name, String description, JCoParameterList jCoParameterList) {
        FunctionComposedMetadata result = new FunctionComposedMetadata(name, description);
        for (JCoField jCoField : Optional.ofNullable(jCoParameterList).orElseGet(Collections::emptyList)) {
            result.addComponent(this.getMetadata(jCoField));
        }
        return result;
    }

    private Metadata getMetadata(String name, String description, JCoStructure structure) {
        FunctionComposedMetadata result = new FunctionComposedMetadata(name, description);
        for (JCoField jCoField : structure) {
            result.addComponent(this.getMetadata(jCoField));
        }
        return result;
    }

    private Metadata getMetadata(String name, String description, JCoTable table) {
        FunctionComposedMetadata result = new FunctionComposedMetadata(name, description);
        FunctionComposedMetadata rowMetadata = new FunctionComposedMetadata("row", "Row");
        for (JCoField jCoField : table) {
            rowMetadata.addComponent(this.getMetadata(jCoField));
        }
        result.addComponent(rowMetadata);
        return result;
    }

    private Metadata getMetadata(JCoField jCoField) {
        Metadata result;
        if (jCoField.isStructure()) {
            try {
                result = this.getMetadata(jCoField.getName(), jCoField.getDescription(), jCoField.getStructure());
            }
            catch (IllegalStateException e) {
                logger.trace("Field has no value; returning generic metadata", (Throwable)e);
                result = new FunctionFieldMetadata(jCoField.getName(), jCoField.getDescription());
            }
        } else if (jCoField.isTable()) {
            try {
                result = this.getMetadata(jCoField.getName(), jCoField.getDescription(), jCoField.getTable());
            }
            catch (IllegalStateException e) {
                logger.trace("Table has no rows; returning generic metadata", (Throwable)e);
                result = new FunctionFieldMetadata(jCoField.getName(), jCoField.getDescription());
            }
        } else {
            result = new FunctionFieldMetadata(jCoField.getName(), jCoField.getDescription());
        }
        return result;
    }

    private void evaluateFunctionResponse(String functionName, JCoRecord resultRecord) {
        if (this.evaluateResponseFlag) {
            String type = resultRecord.getString("TYPE");
            String messageTemplate = "Function [{}] returned with TYPE {} and NUMBER {}: {}";
            if (type != null) {
                if (type.equalsIgnoreCase("E") || type.equalsIgnoreCase("A")) {
                    throw new BusinessObjectExecutionException(this.getMessageFactory().functionErrorResponse(functionName, type, resultRecord.getString("MESSAGE")).getMessage());
                }
                if (type.equalsIgnoreCase("W")) {
                    logger.warn(messageTemplate, new Object[]{functionName, type, this.getResultNumber(resultRecord), resultRecord.getString("MESSAGE")});
                } else if (type.equalsIgnoreCase("I")) {
                    logger.info(messageTemplate, new Object[]{functionName, type, this.getResultNumber(resultRecord), resultRecord.getString("MESSAGE")});
                } else {
                    logger.debug("Function [{}] returned with TYPE {}", (Object)functionName, (Object)type);
                }
            } else {
                logger.debug("Function [{}] returned with TYPE null", (Object)functionName);
            }
        }
    }

    private String getResultNumber(JCoRecord record) {
        if (record != null) {
            if (record.getValue("NUMBER") != null) {
                return record.getValue("NUMBER").toString();
            }
            if (record.getValue("CODE") != null) {
                return record.getValue("CODE").toString();
            }
        }
        return null;
    }

    @Override
    public Map<String, String> getKeys() {
        try {
            BAPIFunction function = new BAPIFunction();
            function.setFunctionName("RFC_FUNCTION_SEARCH");
            function.getImportParameters().add(new Field("FUNCNAME", "*"));
            function = this.tryExecuteSynchronousRFC(function);
            Table resultTable = function.getTableParameters().stream().filter(field -> "FUNCTIONS".equals(field.getName())).map(Table.class::cast).findFirst().orElseGet(Table::new);
            return resultTable.getRows().stream().collect(Collectors.toMap(r -> this.getValue((Structure)r, "FUNCNAME"), r -> this.getValue((Structure)r, "STEXT")));
        }
        catch (BusinessObjectExecutionException e) {
            throw new SearchExecutionException(e);
        }
    }

    private BAPIFunction tryExecuteSynchronousRFC(BAPIFunction function) {
        try {
            function = this.executeSynchronousRFC(function);
        }
        catch (MissingBusinessObjectException e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        return function;
    }

    public String getValue(Structure row, String name) {
        return row.getFields().stream().filter(field -> name.equals(field.getName())).findFirst().map(Field.class::cast).map(Field::getValue).map(Object::toString).orElseThrow(() -> new FieldNotFoundException(name));
    }
}

