/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.sap.extension.internal.service;

import com.sap.conn.jco.JCo;
import com.sap.conn.jco.JCoTraceListener;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.mule.modules.sap.extension.internal.config.SapOutboundConfig;
import org.mule.modules.sap.extension.internal.config.i18n.SapMessageFactory;
import org.mule.modules.sap.extension.internal.connection.SapConnection;
import org.mule.modules.sap.extension.internal.connection.SapJCoTraceListener;
import org.mule.modules.sap.extension.internal.model.BusinessObject;
import org.mule.modules.sap.extension.internal.model.document.IDocument;
import org.mule.modules.sap.extension.internal.service.BusinessObjectService;
import org.mule.modules.sap.extension.internal.service.IdocCollectionSender;
import org.mule.modules.sap.extension.internal.service.RemoteFunctionCall;
import org.mule.modules.sap.extension.internal.service.SapJCoService;
import org.mule.modules.sap.extension.internal.service.TransactionJCoService;
import org.mule.modules.sap.extension.internal.service.TransactionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BusinessObjectJCoService<BO extends BusinessObject, J>
extends SapJCoService
implements BusinessObjectService<BO> {
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final Logger logger = LoggerFactory.getLogger(BusinessObjectJCoService.class);
    private static final SapJCoTraceListener TRACE_LISTENER = new SapJCoTraceListener();
    private static final AtomicBoolean TRACE_LISTENER_INITIALISED = new AtomicBoolean(false);
    private final SapMessageFactory messageFactory;
    private final TransactionService transactionService;

    public BusinessObjectJCoService(SapConnection connection, SapOutboundConfig config) {
        super(connection);
        this.transactionService = new TransactionJCoService(connection);
        this.messageFactory = config.getMessageFactory();
        if (TRACE_LISTENER_INITIALISED != null) {
            if (TRACE_LISTENER_INITIALISED.compareAndSet(false, true) && config.getAdvancedConfig().getLogTraceFlag()) {
                logger.info("JCo trace redirected to standard log files");
                JCo.addTraceListener((JCoTraceListener)TRACE_LISTENER);
                if (System.getProperty("jco.trace_level") == null) {
                    JCo.setTrace((int)4, null);
                }
            }
        } else {
            logger.error("Object not initialized. Need to call startup first.");
        }
    }

    public SapMessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    protected void doAsynchronousCall(BO businessObject, String transactionId, RemoteFunctionCall<J> call) {
        String usedTransactionId = Optional.ofNullable(transactionId).orElseGet(this.transactionService::createTransactionId);
        this.doCall(businessObject, usedTransactionId, call);
        if (transactionId == null) {
            this.transactionService.confirm(usedTransactionId);
        }
    }

    protected void doAsynchronousCall(List<IDocument> businessObjects, String transactionId, IdocCollectionSender<IDocument> call) {
        String usedTransactionId = Optional.ofNullable(transactionId).orElseGet(this.transactionService::createTransactionId);
        this.doCallList(businessObjects, usedTransactionId, call);
        if (transactionId == null) {
            this.transactionService.confirm(usedTransactionId);
        }
    }

    protected abstract BO doCall(BO var1, String var2, RemoteFunctionCall<J> var3);

    protected abstract BO doCallList(List<BO> var1, String var2, IdocCollectionSender<BO> var3);
}

