/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.sap.extension.internal.service;

import com.sap.conn.idoc.IDocDocument;
import com.sap.conn.idoc.IDocDocumentList;
import com.sap.conn.idoc.IDocIllegalTypeException;
import com.sap.conn.idoc.IDocMetaDataUnavailableException;
import com.sap.conn.idoc.IDocParseException;
import com.sap.conn.idoc.IDocSegmentMetaData;
import com.sap.conn.idoc.IDocXMLProcessor;
import com.sap.conn.idoc.jco.JCoIDoc;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoDestinationManager;
import com.sap.conn.jco.JCoException;
import java.io.IOException;
import java.util.List;
import org.mule.modules.sap.extension.internal.connection.SapConnection;
import org.mule.modules.sap.extension.internal.exception.business.MissingBusinessObjectException;
import org.mule.modules.sap.extension.internal.exception.config.UnknownInvalidDestinationException;
import org.mule.modules.sap.extension.internal.exception.mapping.SapXmlParserException;
import org.mule.modules.sap.extension.internal.mapping.SapXmlTransformer;
import org.mule.modules.sap.extension.internal.model.BusinessObject;
import org.mule.modules.sap.extension.internal.model.document.IDocId;
import org.mule.modules.sap.extension.internal.model.document.IDocument;
import org.mule.modules.sap.extension.internal.service.SapServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IDocDocumentDAO {
    private static final Logger logger = LoggerFactory.getLogger(IDocDocumentDAO.class);
    public static final String UTF_8 = "UTF-8";
    private final JCoDestination destination;

    public IDocDocument create(IDocId id) throws MissingBusinessObjectException {
        try {
            logger.debug("About to retrieve idoc [{}]", (Object)id.getIDocId());
            return JCoIDoc.getIDocFactory().createIDocDocument(JCoIDoc.getIDocRepository((JCoDestination)this.destination), id.getIDocType(), id.getIDocExtendedType(), id.getSystemRelease(), id.getApplicationRelease());
        }
        catch (IDocMetaDataUnavailableException | JCoException e) {
            throw new MissingBusinessObjectException(e);
        }
    }

    public IDocSegmentMetaData getRootSegment(String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease) throws MissingBusinessObjectException {
        try {
            logger.debug("About to retrieve metadata with parameters [iDocType={}, iDocTypeExtension={}, systemRelease={}, applicationRelease={}]", new Object[]{iDocType, iDocType, iDocTypeExtension, systemRelease, applicationRelease});
            return JCoIDoc.getIDocRepository((JCoDestination)this.destination).getRootSegmentMetaData(iDocType, iDocTypeExtension, systemRelease, applicationRelease);
        }
        catch (JCoException e) {
            throw new MissingBusinessObjectException(e);
        }
    }

    public IDocDocumentDAO(SapConnection connection) {
        try {
            this.destination = JCoDestinationManager.getDestination((String)connection.getKey());
        }
        catch (JCoException e) {
            throw new UnknownInvalidDestinationException(e);
        }
    }

    public void executeTransactionalRFC(IDocument iDocument, String transactionId) throws JCoException {
        logger.debug("Sending IDoc [{}] over tRFC. TID is [{}]", (Object)iDocument.getName(), (Object)transactionId);
        JCoIDoc.send((IDocDocumentList)this.toIDocDocumentList(iDocument), (char)iDocument.getIDocVersion().charValue(), (JCoDestination)this.destination, (String)transactionId);
    }

    public void executeTransactionalRFC(List<IDocument> iDocuments, String transactionId) throws JCoException {
        logger.debug("Sending IDoc [{}] over tRFC. TID is [{}]", (Object)iDocuments.get(0).getName(), (Object)transactionId);
        JCoIDoc.send((IDocDocumentList)this.toIDocDocumentList(iDocuments), (char)iDocuments.get(0).getIDocVersion().charValue(), (JCoDestination)this.destination, (String)transactionId);
    }

    public void executeQueuedRFC(IDocument iDocument, String transactionId, String queueName) throws JCoException {
        logger.debug("Sending IDoc [{}] over qRFC. Queue name is [{}] and TID is [{}]", new Object[]{iDocument.getName(), queueName, transactionId});
        JCoIDoc.send((IDocDocumentList)this.toIDocDocumentList(iDocument), (char)iDocument.getIDocVersion().charValue(), (JCoDestination)this.destination, (String)transactionId, (String)queueName);
    }

    public IDocDocument create(String iDocumentName) throws JCoException, IDocMetaDataUnavailableException {
        return JCoIDoc.getIDocFactory().createIDocDocument(JCoIDoc.getIDocRepository((JCoDestination)this.destination), iDocumentName);
    }

    private IDocDocumentList toIDocDocumentList(IDocument iDocument) {
        try {
            return JCoIDoc.getIDocFactory().getIDocXMLProcessor().parse(JCoIDoc.getIDocRepository((JCoDestination)this.destination), SapServiceFactory.getInstance().createIDocumentParser().toXml(iDocument, UTF_8));
        }
        catch (IDocParseException | JCoException | IOException e) {
            throw new SapXmlParserException(e);
        }
    }

    private IDocDocumentList toIDocDocumentList(List<IDocument> iDocumentList) {
        try {
            SapXmlTransformer<IDocument> transformer = SapServiceFactory.getInstance().createIDocumentParser();
            IDocXMLProcessor iDocXMLProcessor = JCoIDoc.getIDocFactory().getIDocXMLProcessor();
            IDocDocumentList parentIDocDocumentList = iDocXMLProcessor.parse(JCoIDoc.getIDocRepository((JCoDestination)this.destination), transformer.toXml((IDocument)((BusinessObject)iDocumentList.get(0)), UTF_8));
            iDocumentList.remove(0);
            iDocumentList.stream().map(iDoc -> this.mapIdocToIdocList(transformer, iDocXMLProcessor, (IDocument)iDoc)).map(iDocDocumentList -> iDocDocumentList.get(0)).forEach(iDocDocument -> this.addIdocToParentIdocList(parentIDocDocumentList, (IDocDocument)iDocDocument));
            return parentIDocDocumentList;
        }
        catch (IDocParseException | JCoException | IOException e) {
            throw new SapXmlParserException(e);
        }
    }

    private void addIdocToParentIdocList(IDocDocumentList parentIDocDocumentList, IDocDocument iDocDocument) {
        try {
            parentIDocDocumentList.add(iDocDocument);
        }
        catch (IDocIllegalTypeException e) {
            throw new SapXmlParserException(e);
        }
    }

    private IDocDocumentList mapIdocToIdocList(SapXmlTransformer<IDocument> transformer, IDocXMLProcessor iDocXMLProcessor, IDocument iDoc) {
        try {
            return iDocXMLProcessor.parse(JCoIDoc.getIDocRepository((JCoDestination)this.destination), transformer.toXml(iDoc, UTF_8));
        }
        catch (IDocParseException | JCoException | IOException e) {
            logger.warn("Exception while mapping idoc to list of idoc", e);
            throw new SapXmlParserException(e);
        }
    }

    public void executeQueuedRFC(List<IDocument> iDocument, String transactionId, String queueName) throws JCoException {
        logger.debug("Sending IDoc [{}] over qRFC. Queue name is [{}] and TID is [{}]", new Object[]{iDocument.get(0).getName(), queueName, transactionId});
        JCoIDoc.send((IDocDocumentList)this.toIDocDocumentList(iDocument), (char)iDocument.get(0).getIDocVersion().charValue(), (JCoDestination)this.destination, (String)transactionId, (String)queueName);
    }
}

