/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.sap.extension.internal.service;

import com.sap.conn.idoc.IDocDocument;
import com.sap.conn.idoc.IDocFieldNotFoundException;
import com.sap.conn.idoc.IDocRecordMetaData;
import com.sap.conn.idoc.IDocSegmentMetaData;
import com.sap.conn.idoc.jco.JCoIDoc;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoTable;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.mule.modules.sap.extension.internal.config.SapOutboundConfig;
import org.mule.modules.sap.extension.internal.connection.SapConnection;
import org.mule.modules.sap.extension.internal.error.APIErrorCode;
import org.mule.modules.sap.extension.internal.exception.business.BusinessObjectExecutionException;
import org.mule.modules.sap.extension.internal.exception.business.FieldNotFoundException;
import org.mule.modules.sap.extension.internal.exception.business.MissingBusinessObjectException;
import org.mule.modules.sap.extension.internal.exception.business.SearchExecutionException;
import org.mule.modules.sap.extension.internal.model.document.Component;
import org.mule.modules.sap.extension.internal.model.document.IDocId;
import org.mule.modules.sap.extension.internal.model.document.IDocument;
import org.mule.modules.sap.extension.internal.model.document.LeafSegment;
import org.mule.modules.sap.extension.internal.model.document.Segment;
import org.mule.modules.sap.extension.internal.model.metadata.IDocumentComposedMetadata;
import org.mule.modules.sap.extension.internal.model.metadata.IDocumentFieldMetadata;
import org.mule.modules.sap.extension.internal.model.metadata.Metadata;
import org.mule.modules.sap.extension.internal.service.BusinessObjectJCoService;
import org.mule.modules.sap.extension.internal.service.IDocDocumentDAO;
import org.mule.modules.sap.extension.internal.service.IdocCollectionSender;
import org.mule.modules.sap.extension.internal.service.JCoFunctionDAO;
import org.mule.modules.sap.extension.internal.service.RemoteFunctionCall;
import org.mule.modules.sap.extension.internal.service.SapServiceFactory;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IDocumentJCoService
extends BusinessObjectJCoService<IDocument, IDocument> {
    private static final Logger logger = LoggerFactory.getLogger(BusinessObjectJCoService.class);
    private final IDocDocumentDAO iDocDocumentDAO;
    private final JCoFunctionDAO jCoFunctionDAO;

    public IDocumentJCoService(SapConnection connection, SapOutboundConfig config) {
        super(connection, config);
        this.iDocDocumentDAO = new IDocDocumentDAO(connection);
        this.jCoFunctionDAO = new JCoFunctionDAO(this.getDestination(), config.getAdvancedConfig().getDisableFunctionTemplateCacheFlag());
    }

    @Override
    public IDocument get(String key) throws MissingBusinessObjectException {
        IDocDocument iDocDocument = this.iDocDocumentDAO.create(new IDocId(key));
        IDocument result = SapServiceFactory.getInstance().createIDocumentParser().fromXml(new ByteArrayInputStream(JCoIDoc.getIDocFactory().getIDocXMLProcessor().render(iDocDocument).getBytes(UTF_8)), UTF_8.name());
        for (IDocSegmentMetaData iDocSegmentMetaData : iDocDocument.getRootSegment().getSegmentMetaData().getChildren()) {
            result.add(this.parse(iDocSegmentMetaData));
        }
        IDocRecordMetaData recordMetaData = iDocDocument.getRecordMetaData();
        Segment controlRecord = new Segment(this.getControlRecordName(recordMetaData), this.parse(recordMetaData));
        result.getComponents().stream().filter(Predicate.isEqual(controlRecord)).map(Segment.class::cast).map(Component::getValue).map(segment -> ((List)controlRecord.getValue()).addAll((Collection)controlRecord.getValue()));
        result.add(controlRecord);
        return result;
    }

    public Segment parse(IDocSegmentMetaData metadata) {
        Segment segment = new Segment(metadata.getType());
        ArrayList components = new ArrayList();
        for (IDocSegmentMetaData childMetadata : metadata.getChildren()) {
            components.add(this.parse(childMetadata));
        }
        components.addAll(this.parse(metadata.getRecordMetaData()));
        segment.setValue(components);
        return segment;
    }

    public List<Component<?>> parse(IDocRecordMetaData metadata) {
        ArrayList result = new ArrayList();
        for (int index = 0; index < metadata.getNumFields(); ++index) {
            result.add(new LeafSegment(metadata.getName(index)));
        }
        return result;
    }

    private String getControlRecordName(IDocRecordMetaData recordMetaData) {
        try {
            return recordMetaData.hasField("TABNAM") ? Optional.ofNullable(Arrays.stream(recordMetaData.getValues("TABNAM")).collect(Collectors.joining())).filter(value -> !value.isEmpty()).orElse("EDI_DC40") : "EDI_DC40";
        }
        catch (IDocFieldNotFoundException e) {
            throw new FieldNotFoundException("TABNAM", e);
        }
    }

    @Override
    public Metadata getMetadata(String operationName, String encoding, Character idocVersion) throws MissingBusinessObjectException {
        IDocId iDocId = new IDocId(operationName);
        IDocDocument idoc = this.iDocDocumentDAO.create(iDocId);
        String iDocTypeExtension = this.isBlank(iDocId.getIDocExtendedType()) ? idoc.getRootSegment().getSegmentMetaData().getIDocTypeExtension() : iDocId.getIDocExtendedType();
        String systemRelease = this.isBlank(iDocId.getSystemRelease()) ? idoc.getRootSegment().getSegmentMetaData().getSystemRelease() : iDocId.getSystemRelease();
        String applicationRelease = this.isBlank(iDocId.getApplicationRelease()) ? idoc.getRootSegment().getSegmentMetaData().getApplicationRelease() : iDocId.getApplicationRelease();
        IDocumentComposedMetadata metadata = new IDocumentComposedMetadata(operationName, operationName, 0L, 0L);
        IDocSegmentMetaData rootSegment = this.iDocDocumentDAO.getRootSegment(this.isBlank(iDocId.getIDocType()) ? idoc.getIDocType() : iDocId.getIDocType(), iDocTypeExtension, systemRelease, applicationRelease);
        IDocumentComposedMetadata iDocumentMetadata = new IDocumentComposedMetadata("IDOC", "", 0L, 0L);
        IDocRecordMetaData recordMetaData = idoc.getRecordMetaData();
        IDocumentComposedMetadata controlRecord = new IDocumentComposedMetadata(this.getControlRecordName(recordMetaData), "IDoc Control Record for Interface to External System", 0L, 0L);
        controlRecord.addAttribute("SEGMENT");
        for (int index = 0; index < recordMetaData.getNumFields(); ++index) {
            controlRecord.addComponent(new IDocumentFieldMetadata(recordMetaData.getName(index), recordMetaData.getDescription(index), recordMetaData.getLength(index)));
        }
        iDocumentMetadata.addComponent(controlRecord);
        for (IDocSegmentMetaData iDocSegmentMetadata : rootSegment.getChildren()) {
            iDocumentMetadata.addComponent(this.getMetadata(iDocSegmentMetadata));
        }
        metadata.addComponent(iDocumentMetadata);
        logger.debug("About to retrieve metadata for IDoc [{}] with parameters [iDocType={}, iDocTypeExtension={}, systemRelease={}, applicationRelease={}]", new Object[]{iDocId, iDocId.getIDocType(), iDocTypeExtension, systemRelease, applicationRelease});
        return metadata;
    }

    private boolean isBlank(String value) {
        return Optional.ofNullable(value).map(String::isEmpty).orElse(true);
    }

    public Metadata getMetadata(IDocSegmentMetaData metadata) {
        IDocumentComposedMetadata result = new IDocumentComposedMetadata(metadata.getType(), metadata.getDescription(), metadata.getMinOccurrence(), metadata.getMaxOccurrence());
        result.addAttribute("SEGMENT");
        IDocRecordMetaData recordMetaData = metadata.getRecordMetaData();
        for (int index = 0; index < recordMetaData.getNumFields(); ++index) {
            result.addComponent(new IDocumentFieldMetadata(recordMetaData.getName(index), recordMetaData.getDescription(index), recordMetaData.getLength(index)));
        }
        for (IDocSegmentMetaData childMetadata : metadata.getChildren()) {
            result.setComponents(result.getComponents().stream().filter(value -> !value.getName().equals(childMetadata.getName())).collect(Collectors.toList()));
            result.addComponent(this.getMetadata(childMetadata));
        }
        return result;
    }

    @Override
    public Map<String, String> getKeys() throws SearchExecutionException {
        try {
            int i;
            JCoFunction function = this.jCoFunctionDAO.getFunction("IDOCTYPES_LIST_WITH_MESSAGES");
            this.jCoFunctionDAO.executeSynchronousRFC(function);
            HashMap<String, String> results = new HashMap<String, String>();
            JCoTable resultTable = function.getTableParameterList().getTable("PT_IDOCTYPES");
            for (i = 0; i < resultTable.getNumRows(); ++i) {
                resultTable.setRow(i);
                results.put(resultTable.getString("IDOCTYP"), resultTable.getString("DESCRP"));
            }
            resultTable = function.getTableParameterList().getTable("PT_EXTTYPES");
            for (i = 0; i < resultTable.getNumRows(); ++i) {
                resultTable.setRow(i);
                IDocId iDocId = new IDocId();
                iDocId.setIDocType(resultTable.getString("IDOCTYP"));
                iDocId.setIDocExtendedType(resultTable.getString("CIMTYP"));
                results.put(iDocId.getIDocId(), resultTable.getString("DESCRP"));
            }
            return results;
        }
        catch (JCoException | MissingBusinessObjectException e) {
            throw new SearchExecutionException(e);
        }
    }

    @Override
    public void executeTransactionalRFC(IDocument iDocument, String transactionId) {
        this.doAsynchronousCall(iDocument, transactionId, (J jCoIDocument, String usedTransactionId) -> this.iDocDocumentDAO.executeTransactionalRFC((IDocument)jCoIDocument, usedTransactionId));
    }

    @Override
    public void executeQueuedRFC(IDocument iDocument, String transactionId, String queueName) {
        this.doAsynchronousCall(iDocument, transactionId, (J jCoIDocument, String usedTransactionId) -> this.iDocDocumentDAO.executeQueuedRFC((IDocument)jCoIDocument, usedTransactionId, queueName));
    }

    @Override
    public void executeQueuedRFCIdocCollection(List<IDocument> businessObject, String transactionId, String queueName) {
        this.doAsynchronousCall(businessObject, transactionId, (List<IDocument> jCoIDocument, String usedTransactionId) -> this.iDocDocumentDAO.executeQueuedRFC(jCoIDocument, usedTransactionId, queueName));
    }

    @Override
    public void executeTransactionalRFCFIdocCollection(List<IDocument> businessObject, String transactionId, String queueName) {
        this.doAsynchronousCall(businessObject, transactionId, (List<IDocument> jCoIDocument, String usedTransactionId) -> this.iDocDocumentDAO.executeTransactionalRFC(jCoIDocument, usedTransactionId));
    }

    @Override
    protected IDocument doCall(IDocument iDocument, String transactionId, RemoteFunctionCall<IDocument> call) {
        try {
            call.execute(iDocument, transactionId);
            logger.debug("IDoc [{}] sent successfully.", (Object)iDocument.getName());
            return null;
        }
        catch (JCoException e) {
            throw new BusinessObjectExecutionException(e);
        }
    }

    @Override
    protected IDocument doCallList(List<IDocument> businessObject, String transactionId, IdocCollectionSender<IDocument> call) {
        try {
            call.execute(businessObject, transactionId);
        }
        catch (JCoException e) {
            throw new ModuleException((ErrorTypeDefinition)APIErrorCode.EXECUTION_ERROR, (Throwable)e);
        }
        return null;
    }

    @Override
    public IDocument executeSynchronousRFC(IDocument businessObject) throws MissingBusinessObjectException, BusinessObjectExecutionException {
        throw new UnsupportedOperationException("IDocuments don't support Synchronized Remote Function Calls.");
    }
}

