/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.sap.extension.internal.service;

import com.sap.conn.jco.JCoField;
import com.sap.conn.jco.JCoTable;
import com.sap.conn.jco.util.Codecs;
import java.nio.charset.Charset;
import java.util.Optional;
import java.util.stream.StreamSupport;
import org.mule.modules.sap.extension.internal.model.function.Field;
import org.mule.modules.sap.extension.internal.model.function.ParameterFieldVisitor;
import org.mule.modules.sap.extension.internal.model.function.Structure;
import org.mule.modules.sap.extension.internal.model.function.Table;

public class JCoFieldParser
implements ParameterFieldVisitor {
    private final JCoField jCoField;

    public JCoFieldParser(JCoField jCoField) {
        this.jCoField = jCoField;
    }

    @Override
    public void visit(Table table) {
        JCoTable jCoTable = this.jCoField.getTable();
        for (Structure row : table.getRows()) {
            jCoTable.appendRow();
            this.doVisit((Iterable<JCoField>)jCoTable, row);
        }
    }

    @Override
    public void visit(Structure structure) {
        this.doVisit((Iterable<JCoField>)this.jCoField.getStructure(), structure);
    }

    private void doVisit(Iterable<JCoField> jcoField, Structure structure) {
        StreamSupport.stream(jcoField.spliterator(), false).forEach(field -> structure.getFields().stream().filter(structureField -> structureField.getName().equals(field.getName())).forEach(structureField -> structureField.accept(new JCoFieldParser((JCoField)field))));
    }

    @Override
    public void visit(Field field) {
        this.jCoField.setValue(this.jCoField.getType() == 30 ? (Object)Codecs.Base64.decode((byte[])Optional.ofNullable(field.getValue()).map(String.class::cast).orElse("").getBytes(Charset.forName("UTF-8"))) : field.getValue());
    }
}

