/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.sap.extension.internal.service;

import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunction;
import org.mule.modules.sap.extension.internal.exception.business.BusinessObjectExecutionException;
import org.mule.modules.sap.extension.internal.exception.business.MissingBusinessObjectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCoFunctionDAO {
    private static final Logger logger = LoggerFactory.getLogger(JCoFunctionDAO.class);
    private final boolean disableCache;
    private JCoDestination destination;

    public JCoFunctionDAO(JCoDestination destination, boolean disableCache) {
        this.disableCache = disableCache;
        this.destination = destination;
    }

    public JCoFunction getFunction(String functionName) {
        try {
            JCoFunction functionTemplate = null;
            if (functionName != null) {
                functionName = functionName.replaceAll("_-", "/");
                functionTemplate = this.destination.getRepository().getFunction(functionName);
                if (this.disableCache) {
                    this.destination.getRepository().clear();
                }
            }
            if (functionTemplate == null) {
                throw new MissingBusinessObjectException("Missing function template with name '%s'", (Object)functionName);
            }
            return functionTemplate;
        }
        catch (JCoException e) {
            throw new BusinessObjectExecutionException("An error occurred while retrieving the the function template.", (Throwable)e, functionName);
        }
    }

    public void executeSynchronousRFC(JCoFunction function) throws JCoException {
        logger.debug("Executing function [{}] over sRFC.", (Object)function.getName());
        function.execute(this.destination);
    }

    public void executeTransactionalRFC(JCoFunction function, String transactionId) throws JCoException {
        logger.debug("Executing function [{}] over tRFC. TID is [{}]", (Object)function.getName(), (Object)transactionId);
        function.execute(this.destination, transactionId);
    }

    public void executeQueuedRFC(JCoFunction function, String transactionId, String queueName) throws JCoException {
        logger.debug("Executing function [{}] over {} qRFC. Queue name is [{}] and TID is [{}]", new Object[]{function.getName(), queueName, transactionId});
        function.execute(this.destination, transactionId, queueName);
    }
}

