/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.sap.extension.internal.service;

import com.sap.conn.idoc.IDocConversionException;
import com.sap.conn.idoc.IDocDocument;
import com.sap.conn.idoc.IDocSegment;
import com.sap.conn.jco.AbapException;
import com.sap.conn.jco.JCoField;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoParameterList;
import com.sap.conn.jco.JCoTable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.StreamSupport;
import org.mule.modules.sap.extension.internal.exception.business.FieldNotFoundException;
import org.mule.modules.sap.extension.internal.model.document.Component;
import org.mule.modules.sap.extension.internal.model.document.IDocument;
import org.mule.modules.sap.extension.internal.model.document.LeafSegment;
import org.mule.modules.sap.extension.internal.model.document.Segment;
import org.mule.modules.sap.extension.internal.model.function.AbapInternalException;
import org.mule.modules.sap.extension.internal.model.function.BAPIFunction;
import org.mule.modules.sap.extension.internal.model.function.Field;
import org.mule.modules.sap.extension.internal.model.function.ParameterField;
import org.mule.modules.sap.extension.internal.model.function.Structure;
import org.mule.modules.sap.extension.internal.model.function.Table;
import org.mule.modules.sap.extension.internal.service.JCoFieldParser;

public class JCoToBusinessObjectParser {
    private boolean useSAPDefaultFormat;

    public JCoToBusinessObjectParser() {
        this.useSAPDefaultFormat = false;
    }

    public JCoToBusinessObjectParser(boolean useSAPDefaultFormat) {
        this.useSAPDefaultFormat = useSAPDefaultFormat;
    }

    public void parse(JCoFunction jCoFunction, BAPIFunction bapiFunction) {
        this.parse(jCoFunction.getImportParameterList(), bapiFunction.getImportParameters());
        this.parse(jCoFunction.getExportParameterList(), bapiFunction.getExportParameters());
        this.parse(jCoFunction.getChangingParameterList(), bapiFunction.getChangingParameters());
        this.parse(jCoFunction.getTableParameterList(), bapiFunction.getTableParameters());
    }

    private void parse(JCoParameterList jCoParameterList, List<ParameterField> parameterList) {
        StreamSupport.stream(Optional.ofNullable(jCoParameterList).orElseGet(ArrayList::new).spliterator(), false).forEach(jCoField -> parameterList.stream().filter(parameterListField -> parameterListField.getName().equals(jCoField.getName())).forEach(parameterListField -> parameterListField.accept(new JCoFieldParser((JCoField)jCoField))));
    }

    public BAPIFunction parse(JCoFunction jCoFunction) {
        BAPIFunction bapiFunction = new BAPIFunction();
        bapiFunction.setFunctionName(jCoFunction.getName());
        bapiFunction.setImportParameters(this.parse(jCoFunction.getImportParameterList()));
        bapiFunction.setExportParameters(this.parse(jCoFunction.getExportParameterList()));
        bapiFunction.setChangingParameters(this.parse(jCoFunction.getChangingParameterList()));
        bapiFunction.setTableParameters(this.parse(jCoFunction.getTableParameterList()));
        for (AbapException abapException : Optional.ofNullable(jCoFunction.getExceptionList()).orElse(new AbapException[0])) {
            bapiFunction.getExceptionList().add(new AbapInternalException(abapException.getKey(), abapException.getMessageClass(), abapException.getMessageNumber(), abapException.getMessageText(), (Throwable)abapException));
        }
        return bapiFunction;
    }

    private List<ParameterField> parse(JCoParameterList list) {
        ArrayList<ParameterField> result = new ArrayList<ParameterField>();
        for (JCoField field : Optional.ofNullable(list).orElseGet(ArrayList::new)) {
            result.add(this.parse(field));
        }
        return result;
    }

    private ParameterField parse(JCoField jCoField) {
        ParameterField parameterField;
        if (jCoField.isStructure()) {
            Structure structure = new Structure(jCoField.getName());
            for (JCoField child : jCoField.getStructure()) {
                structure.add(this.parse(child));
            }
            parameterField = structure;
        } else if (jCoField.isTable()) {
            JCoTable jCoTable = jCoField.getTable();
            Table table = new Table(jCoField.getName());
            for (int rowIndex = 0; rowIndex < jCoTable.getNumRows(); ++rowIndex) {
                Structure row = new Structure(Table.ROW_TAG);
                for (JCoField rowElement : jCoTable) {
                    row.add(this.parse(rowElement));
                }
                table.add(row);
                jCoTable.nextRow();
            }
            parameterField = table;
        } else {
            parameterField = this.useSAPDefaultFormat ? new Field(jCoField.getName(), jCoField.getString()) : new Field(jCoField.getName(), jCoField.getType() == 30 ? jCoField.getString() : Optional.ofNullable(jCoField.getValue()).orElse(""));
        }
        return parameterField;
    }

    public IDocument parse(IDocDocument iDocDocument) {
        IDocument iDocument = new IDocument();
        iDocument.setName(iDocDocument.getIDocType());
        iDocument.getComponents().addAll(this.parse(iDocDocument.getRootSegment()));
        return iDocument;
    }

    private List<Component<?>> parse(IDocSegment iDocSegment) {
        ArrayList result = new ArrayList();
        for (int i = 0; i < iDocSegment.getChildren().length; ++i) {
            IDocSegment child = iDocSegment.getChild(i);
            String name = child.getType();
            if (child.isParent()) {
                result.add(new Segment(name, this.parse(child)));
                continue;
            }
            try {
                result.add(new LeafSegment(name, Optional.ofNullable(iDocSegment.getValue(i)).orElse("").toString()));
                continue;
            }
            catch (IDocConversionException e) {
                throw new FieldNotFoundException(child.getType(), e);
            }
        }
        return result;
    }
}

