/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.sap.extension.internal.service;

import org.mule.modules.sap.extension.internal.config.SapConfig;
import org.mule.modules.sap.extension.internal.config.SapOutboundConfig;
import org.mule.modules.sap.extension.internal.connection.SapConnection;
import org.mule.modules.sap.extension.internal.mapping.BAPIFunctionXmlTransformer;
import org.mule.modules.sap.extension.internal.mapping.BapiFunctionStaxXmlTransformer;
import org.mule.modules.sap.extension.internal.mapping.IDocumentXmlTransformer;
import org.mule.modules.sap.extension.internal.mapping.SapXmlTransformer;
import org.mule.modules.sap.extension.internal.model.document.IDocument;
import org.mule.modules.sap.extension.internal.model.function.BAPIFunction;
import org.mule.modules.sap.extension.internal.service.BAPIFunctionJCoService;
import org.mule.modules.sap.extension.internal.service.BusinessObjectService;
import org.mule.modules.sap.extension.internal.service.IDocumentJCoService;
import org.mule.modules.sap.extension.internal.service.TransactionJCoService;
import org.mule.modules.sap.extension.internal.service.TransactionService;

public class SapServiceFactory {
    private static final SapServiceFactory instance = new SapServiceFactory();
    private final BAPIFunctionXmlTransformer bapiFunctionXMLTransformer = new BAPIFunctionXmlTransformer();
    private final IDocumentXmlTransformer iDocumentXmlTransformer = new IDocumentXmlTransformer();
    private final BapiFunctionStaxXmlTransformer bapiFunctionStaxXmlTransformer = new BapiFunctionStaxXmlTransformer();

    public BusinessObjectService<BAPIFunction> createBAPIFunctionService(SapOutboundConfig config, SapConnection connection) {
        return new BAPIFunctionJCoService(connection, config);
    }

    public BusinessObjectService<IDocument> createIDocumentService(SapOutboundConfig config, SapConnection connection) {
        return new IDocumentJCoService(connection, config);
    }

    public SapXmlTransformer<BAPIFunction> createBAPIFunctionParser() {
        return this.bapiFunctionXMLTransformer;
    }

    public SapXmlTransformer<BAPIFunction> createBAPIFunctionStaxParser() {
        return this.bapiFunctionStaxXmlTransformer;
    }

    public SapXmlTransformer<IDocument> createIDocumentParser() {
        return this.iDocumentXmlTransformer;
    }

    public static SapServiceFactory getInstance() {
        return instance;
    }

    public TransactionService createTransactionService(SapConfig config, SapConnection connection) {
        return new TransactionJCoService(connection);
    }
}

