/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.sap.extension.internal.source;

import java.io.InputStream;
import org.mule.modules.sap.extension.api.SapAttributes;
import org.mule.modules.sap.extension.internal.config.SapInboundConfig;
import org.mule.modules.sap.extension.internal.connection.SapConnection;
import org.mule.modules.sap.extension.internal.exception.config.SapServerException;
import org.mule.modules.sap.extension.internal.source.server.SapServer;
import org.mule.modules.sap.extension.internal.source.server.builder.IDocumentServerBuilder;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;

@MediaType(value="application/xml")
public class DocumentSource
extends Source<InputStream, SapAttributes> {
    @Parameter
    private Long operationTimeout;
    @Parameter
    private String gatewayHost;
    @Parameter
    private String gatewayService;
    @Parameter
    private String programID;
    @Parameter
    @Optional(defaultValue="1")
    private Integer connectionCount;
    @Config
    private SapInboundConfig config;
    @Connection
    private ConnectionProvider<SapConnection> connectionProvider;
    private SapServer server;

    public void onStart(SourceCallback<InputStream, SapAttributes> sourceCallback) throws MuleException {
        try {
            this.server = new IDocumentServerBuilder((SapConnection)this.connectionProvider.connect(), this.programID, this.config.getEncoding(), sourceCallback).withConnectionCount(this.connectionCount).withGatewayHost(this.gatewayHost).withGatewayService(this.gatewayService).create();
            this.server.start();
        }
        catch (SapServerException e) {
            sourceCallback.onConnectionException(new ConnectionException((Throwable)e));
        }
    }

    public void onStop() {
        this.server.stop();
    }

    public long getOperationTimeout() {
        return this.operationTimeout;
    }

    public String getGatewayHost() {
        return this.gatewayHost;
    }

    public String getGatewayService() {
        return this.gatewayService;
    }

    public String getProgramId() {
        return this.programID;
    }

    public Integer getConnectionCount() {
        return this.connectionCount;
    }

    public void setOperationTimeout(Long operationTimeout) {
        this.operationTimeout = operationTimeout;
    }

    public void setGatewayHost(String gatewayHost) {
        this.gatewayHost = gatewayHost;
    }

    public void setGatewayService(String gatewayService) {
        this.gatewayService = gatewayService;
    }

    public void setProgramID(String programID) {
        this.programID = programID;
    }

    public void setConnectionCount(Integer connectionCount) {
        this.connectionCount = connectionCount;
    }

    public String getProgramID() {
        return this.programID;
    }

    public SapInboundConfig getConfig() {
        return this.config;
    }

    public void setConfig(SapInboundConfig config) {
        this.config = config;
    }

    public ConnectionProvider<SapConnection> getConnectionProvider() {
        return this.connectionProvider;
    }

    public void setConnectionProvider(ConnectionProvider<SapConnection> connectionProvider) {
        this.connectionProvider = connectionProvider;
    }
}

