/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.sap.extension.internal.source;

import java.io.InputStream;
import java.nio.charset.Charset;
import org.mule.modules.sap.extension.api.SapAttributes;
import org.mule.modules.sap.extension.internal.config.SapInboundConfig;
import org.mule.modules.sap.extension.internal.connection.SapConnection;
import org.mule.modules.sap.extension.internal.exception.config.SapServerException;
import org.mule.modules.sap.extension.internal.source.server.SapJCoServer;
import org.mule.modules.sap.extension.internal.source.server.SapServer;
import org.mule.modules.sap.extension.internal.source.server.builder.BAPIFunctionServerBuilder;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.annotation.execution.OnError;
import org.mule.runtime.extension.api.annotation.execution.OnSuccess;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.source.EmitsResponse;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MediaType(value="application/xml")
@EmitsResponse
public class FunctionSource
extends Source<InputStream, SapAttributes> {
    private static final String UTF_8 = "UTF-8";
    private static final String TID = "tid";
    private static final String FLOW_RESPONSE = "flowResponse";
    @Parameter
    private Long operationTimeout;
    @Parameter
    private String gatewayHost;
    @Parameter
    private String gatewayService;
    @Parameter
    private String programID;
    @Parameter
    @Optional(defaultValue="1")
    private Integer connectionCount;
    @Parameter
    @Optional
    private String targetedFunction;
    @Config
    private SapInboundConfig config;
    @Connection
    private ConnectionProvider<SapConnection> connectionProvider;
    private SapServer server;
    private static final Logger logger = LoggerFactory.getLogger(FunctionSource.class);

    public void onStart(SourceCallback<InputStream, SapAttributes> sourceCallback) throws MuleException {
        try {
            this.server = new BAPIFunctionServerBuilder((SapConnection)this.connectionProvider.connect(), this.programID, this.targetedFunction, this.config.getEncoding(), sourceCallback).withConnectionCount(this.connectionCount).withGatewayHost(this.gatewayHost).withGatewayService(this.gatewayService).create();
            this.server.start();
        }
        catch (SapServerException e) {
            sourceCallback.onConnectionException(new ConnectionException((Throwable)e));
        }
    }

    @OnSuccess
    public void onSuccess(@Content InputStream response, SourceCallbackContext context) {
        if (context.getVariable(TID).isPresent()) {
            this.server.onSuccess((String)context.getVariable(TID).get());
        }
        context.addVariable(FLOW_RESPONSE, (Object)IOUtils.toString((InputStream)response, (Charset)Charset.forName(UTF_8)));
        this.server.notifyOnSuccessPerformed(context);
        if (this.server instanceof SapJCoServer) {
            ((SapJCoServer)this.server).getJcoServer().getRepository().clear();
        }
    }

    @OnError
    public void onException(SourceCallbackContext context) {
        if (context.getVariable(TID).isPresent()) {
            this.server.onError((String)context.getVariable(TID).get());
        }
        this.server.notifyOnExceptionPerformed(context);
    }

    public void onStop() {
        this.server.stop();
    }

    public SapInboundConfig getConfig() {
        return this.config;
    }

    public void setConfig(SapInboundConfig config) {
        this.config = config;
    }

    public Long getOperationTimeout() {
        return this.operationTimeout;
    }

    public Integer getConnectionCount() {
        return this.connectionCount;
    }

    public String getGatewayHost() {
        return this.gatewayHost;
    }

    public String getGatewayService() {
        return this.gatewayService;
    }

    public String getProgramID() {
        return this.programID;
    }

    public String getTargetedFunction() {
        return this.targetedFunction;
    }

    public void setProgramID(String programID) {
        this.programID = programID;
    }

    public void setConnectionCount(Integer connectionCount) {
        this.connectionCount = connectionCount;
    }

    public void setGatewayHost(String gatewayHost) {
        this.gatewayHost = gatewayHost;
    }

    public void setGatewayService(String gatewayService) {
        this.gatewayService = gatewayService;
    }

    public void setOperationTimeout(Long operationTimeout) {
        this.operationTimeout = operationTimeout;
    }

    public void setTargetedFunction(String targetedFunction) {
        this.targetedFunction = targetedFunction;
    }

    public ConnectionProvider<SapConnection> getConnectionProvider() {
        return this.connectionProvider;
    }

    public void setConnectionProvider(ConnectionProvider<SapConnection> connectionProvider) {
        this.connectionProvider = connectionProvider;
    }
}

