/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.sap.extension.internal.source.server;

import com.sap.conn.idoc.IDocDocument;
import com.sap.conn.idoc.IDocDocumentList;
import com.sap.conn.idoc.IDocXMLProcessor;
import com.sap.conn.idoc.jco.JCoIDoc;
import com.sap.conn.idoc.jco.JCoIDocHandler;
import com.sap.conn.idoc.jco.JCoIDocHandlerFactory;
import com.sap.conn.idoc.jco.JCoIDocQueueHandler;
import com.sap.conn.idoc.jco.JCoIDocServerContext;
import com.sap.conn.jco.AbapClassException;
import com.sap.conn.jco.AbapException;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoDestinationManager;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoParameterList;
import com.sap.conn.jco.server.JCoServer;
import com.sap.conn.jco.server.JCoServerContext;
import com.sap.conn.jco.server.JCoServerContextInfo;
import com.sap.conn.jco.server.JCoServerErrorListener;
import com.sap.conn.jco.server.JCoServerExceptionListener;
import com.sap.conn.jco.server.JCoServerFunctionHandler;
import com.sap.conn.jco.server.JCoServerState;
import com.sap.conn.jco.server.JCoServerStateChangedListener;
import com.sap.conn.jco.server.JCoServerTIDHandler;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.modules.sap.extension.api.SapAttributes;
import org.mule.modules.sap.extension.internal.connection.SapConnection;
import org.mule.modules.sap.extension.internal.error.APIErrorCode;
import org.mule.modules.sap.extension.internal.exception.config.InvalidConfigurationException;
import org.mule.modules.sap.extension.internal.exception.mapping.SapXmlParserException;
import org.mule.modules.sap.extension.internal.exception.transaction.ConfirmTransactionException;
import org.mule.modules.sap.extension.internal.mapping.BAPIFunctionXmlTransformer;
import org.mule.modules.sap.extension.internal.mapping.IDocumentXmlTransformer;
import org.mule.modules.sap.extension.internal.mapping.SapXmlTransformer;
import org.mule.modules.sap.extension.internal.model.document.IDocument;
import org.mule.modules.sap.extension.internal.model.function.BAPIFunction;
import org.mule.modules.sap.extension.internal.model.function.Field;
import org.mule.modules.sap.extension.internal.model.function.ParameterField;
import org.mule.modules.sap.extension.internal.service.JCoToBusinessObjectParser;
import org.mule.modules.sap.extension.internal.source.server.SapServer;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SapJCoServer
implements JCoServerStateChangedListener,
JCoServerErrorListener,
JCoServerExceptionListener,
JCoServerTIDHandler,
JCoIDocHandlerFactory,
JCoServerFunctionHandler,
JCoIDocHandler,
JCoIDocQueueHandler,
SapServer {
    private static final Logger logger = LoggerFactory.getLogger(SapJCoServer.class);
    private static final List<JCoServerState> UP_STATES = Stream.builder().add(JCoServerState.ALIVE).add(JCoServerState.STARTED).build().collect(Collectors.toList());
    private static final String UTF_8 = "UTF-8";
    private static final String FLOW_RESPONSE = "flowResponse";
    private static final String EXPORT_PARAMETER = "<export>";
    public static final String TID = "tid";
    private final Set<String> keys = new HashSet<String>();
    private final JCoServer server;
    private final SourceCallback<InputStream, SapAttributes> sourceCallback;
    private final SapXmlTransformer<BAPIFunction> bapiFunctionSapXmlTransformer = new BAPIFunctionXmlTransformer();
    private final SapXmlTransformer<IDocument> iDocumentSapXmlTransformer = new IDocumentXmlTransformer();
    private final JCoToBusinessObjectParser parser = new JCoToBusinessObjectParser();
    private final String encoding;
    private JCoDestination destination;

    public SapJCoServer(JCoServer server, SapConnection connection, SourceCallback<InputStream, SapAttributes> sourceCallback, String encoding) {
        this.server = server;
        this.setDestination(connection.getKey());
        this.sourceCallback = sourceCallback;
        this.encoding = encoding;
    }

    @Override
    public void start() {
        this.server.addServerErrorListener((JCoServerErrorListener)this);
        this.server.addServerExceptionListener((JCoServerExceptionListener)this);
        this.server.addServerStateChangedListener((JCoServerStateChangedListener)this);
        this.server.setTIDHandler((JCoServerTIDHandler)this);
        this.server.start();
    }

    @Override
    public synchronized void stop() {
        if (UP_STATES.contains(this.server.getState())) {
            this.server.stop();
        }
    }

    @Override
    public void onSuccess(String transactionId) {
        try {
            this.destination.confirmTID(transactionId);
        }
        catch (JCoException e) {
            throw new ConfirmTransactionException(e);
        }
    }

    @Override
    public void onError(String transactionId) {
    }

    public void serverErrorOccurred(JCoServer jCoServer, String connectionId, JCoServerContextInfo contextInfo, Error error) {
        logger.error("A critical error occurred on the server '{}'. Shutting down the connection with ID {}", (Object)jCoServer.getProgramID(), (Object)connectionId);
        this.stop();
    }

    public void serverExceptionOccurred(JCoServer jCoServer, String connectionId, JCoServerContextInfo jCoServerContextInfo, Exception exception) {
        logger.warn("The server '{}' reported an error for connectionID {}.", new Object[]{jCoServer.getProgramID(), connectionId, exception});
    }

    public void serverStateChangeOccurred(JCoServer jCoServer, JCoServerState oldState, JCoServerState newState) {
        logger.debug("JCo server {} changed it's state from {} to {}.", new Object[]{jCoServer.getProgramID(), oldState.name(), newState.name()});
    }

    public boolean checkTID(JCoServerContext jCoServerContext, String transactionId) {
        return !this.keys.contains(transactionId);
    }

    public void confirmTID(JCoServerContext jCoServerContext, String transactionId) {
        this.keys.remove(transactionId);
    }

    public void commit(JCoServerContext jCoServerContext, String transactionId) {
    }

    public void rollback(JCoServerContext jCoServerContext, String transactionId) {
        this.keys.remove(transactionId);
    }

    public JCoIDocHandler getIDocHandler(JCoIDocServerContext jCoIDocServerContext) {
        return this;
    }

    public void handleRequest(JCoServerContext jCoServerContext, IDocDocumentList iDocDocumentList) {
        String transactionId = jCoServerContext.getTID();
        this.keys.add(transactionId);
        Arrays.stream(iDocDocumentList.toArray()).map(this.parser::parse).map(iDocument -> this.iDocumentSapXmlTransformer.toXml((IDocument)iDocument, this.encoding)).forEach(iDocument -> this.handle(transactionId, (InputStream)iDocument));
    }

    public void handleRequest(JCoServerContext jCoServerContext, JCoFunction jCoFunction) throws AbapException, AbapClassException {
        String transactionId = jCoServerContext.getTID();
        this.keys.add(transactionId);
        this.handle(transactionId, Optional.of(jCoFunction).map(this.parser::parse).map(bapiFunction -> this.bapiFunctionSapXmlTransformer.toXml((BAPIFunction)bapiFunction, this.encoding)).get(), jCoFunction);
    }

    public void handleRequest(JCoIDocServerContext jCoIDocServerContext, IDocDocumentList[] iDocDocumentLists) {
        String transactionId = jCoIDocServerContext.getJCoServerContext().getTID();
        this.keys.add(transactionId);
        for (IDocDocumentList iDocDocumentList : iDocDocumentLists) {
            this.handle(transactionId, new ByteArrayInputStream(this.sapToXml(iDocDocumentList, this.encoding).getBytes(Charset.forName(UTF_8))));
        }
    }

    private String sapToXml(Object sapObject, String encoding) {
        String result = null;
        logger.debug("About to transform {} -> {} to XML String", sapObject, (Object)(sapObject != null ? sapObject.getClass().getName() : "null"));
        if (sapObject instanceof IDocDocument) {
            IDocDocument document = (IDocDocument)sapObject;
            try {
                result = this.transformIDocDocument(document, encoding);
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
                throw new SapXmlParserException(ex.getMessage(), ex.getCause());
            }
        } else if (sapObject instanceof IDocDocumentList) {
            IDocDocumentList documentList = (IDocDocumentList)sapObject;
            try {
                result = this.transformIDocDocument(documentList, encoding);
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
                throw new SapXmlParserException(ex.getMessage(), ex.getCause());
            }
        } else if (sapObject != null) {
            logger.error("Unsupported payload class: {}", (Object)sapObject.getClass().getName());
        }
        return result;
    }

    private String transformIDocDocument(IDocDocumentList documentList, String encoding) {
        IDocXMLProcessor xmlProcessor = JCoIDoc.getIDocFactory().getIDocXMLProcessor();
        return xmlProcessor.render(documentList, encoding, 7);
    }

    private String transformIDocDocument(IDocDocument document, String encoding) {
        IDocXMLProcessor xmlProcessor = JCoIDoc.getIDocFactory().getIDocXMLProcessor();
        return xmlProcessor.render(document, encoding, 7);
    }

    private void handle(String transactionId, InputStream output, JCoFunction jCoFunction) {
        SourceCallbackContext context = this.sourceCallback.createContext();
        context.addVariable(TID, (Object)transactionId);
        if (jCoFunction != null) {
            this.handleFunction(this.sourceCallback, output, jCoFunction, context, transactionId);
        } else {
            this.sourceCallback.handle(Result.builder().attributes((Object)new SapAttributes(transactionId)).output((Object)output).build(), context);
        }
    }

    private void handle(String transactionId, InputStream output) {
        SourceCallbackContext context = this.sourceCallback.createContext();
        context.addVariable(TID, (Object)transactionId);
        this.sourceCallback.handle(Result.builder().attributes((Object)new SapAttributes(transactionId)).output((Object)output).build(), context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleFunction(SourceCallback<InputStream, SapAttributes> sourceCallback, InputStream output, JCoFunction jCoFunction, SourceCallbackContext context, String transactionId) {
        try {
            logger.info("Waiting for the mule flow response");
            SourceCallbackContext sourceCallbackContext = context;
            synchronized (sourceCallbackContext) {
                sourceCallback.handle(Result.builder().attributes((Object)new SapAttributes(transactionId)).output((Object)output).build(), context);
                context.wait();
            }
        }
        catch (InterruptedException e) {
            throw new ModuleException("Interrupted exception while waiting for onSuccess function call", (ErrorTypeDefinition)APIErrorCode.UNKNOWN, (Throwable)e);
        }
        String flowResponse = context.getVariable(FLOW_RESPONSE).isPresent() ? (String)context.getVariable(FLOW_RESPONSE).get() : null;
        logger.info("Flow response is " + flowResponse);
        if (flowResponse != null && flowResponse.contains(EXPORT_PARAMETER)) {
            this.handleFunctionWithExportParameters(flowResponse, jCoFunction);
        }
    }

    private void handleFunctionWithExportParameters(String flowResponse, JCoFunction jCoFunction) {
        logger.debug("Provided function contains export parameters");
        BAPIFunction resultedFunction = new BAPIFunctionXmlTransformer().fromXml(new ByteArrayInputStream(flowResponse.getBytes(StandardCharsets.UTF_8)), UTF_8);
        List<ParameterField> resultedFunctionExportParameters = resultedFunction.getExportParameters();
        JCoParameterList initialExportParameters = jCoFunction.getExportParameterList();
        initialExportParameters.forEach(jCoField -> {
            Optional<ParameterField> jcoExportFieldValue = resultedFunctionExportParameters.stream().filter(parameterField -> parameterField.getName().equals(jCoField.getName())).findFirst();
            jcoExportFieldValue.ifPresent(value -> jCoField.setValue(((Field)jcoExportFieldValue.get()).getValue()));
        });
    }

    public void setDestination(String connectionKey) {
        try {
            this.destination = JCoDestinationManager.getDestination((String)connectionKey);
        }
        catch (JCoException e) {
            throw new InvalidConfigurationException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyOnSuccessPerformed(SourceCallbackContext context) {
        SourceCallbackContext sourceCallbackContext = context;
        synchronized (sourceCallbackContext) {
            context.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyOnExceptionPerformed(SourceCallbackContext context) {
        SourceCallbackContext sourceCallbackContext = context;
        synchronized (sourceCallbackContext) {
            context.notify();
        }
    }

    public JCoServer getJcoServer() {
        return this.server;
    }
}

