/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.sap.extension.internal.source.server.builder;

import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.server.DefaultServerHandlerFactory;
import com.sap.conn.jco.server.JCoServer;
import com.sap.conn.jco.server.JCoServerCallHandlerFactory;
import com.sap.conn.jco.server.JCoServerFactory;
import java.io.InputStream;
import java.util.Optional;
import org.mule.modules.sap.extension.api.SapAttributes;
import org.mule.modules.sap.extension.internal.connection.SapConnection;
import org.mule.modules.sap.extension.internal.connection.SapJCoDataProvider;
import org.mule.modules.sap.extension.internal.exception.config.SapServerInitializationException;
import org.mule.modules.sap.extension.internal.source.server.SapJCoServer;
import org.mule.modules.sap.extension.internal.source.server.builder.SapServerBuilder;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;

public class BAPIFunctionServerBuilder
extends SapServerBuilder {
    private String targetFunction;

    public BAPIFunctionServerBuilder(SapConnection connection, String programId, String targetFunction, String encoding, SourceCallback<InputStream, SapAttributes> sourceCallback) {
        super(connection, programId, encoding, sourceCallback);
        this.targetFunction = targetFunction;
    }

    @Override
    protected SapJCoServer create(SapConnection connection, String programId, String encoding, SourceCallback<InputStream, SapAttributes> sourceCallback) {
        try {
            JCoServer server = JCoServerFactory.getServer((String)programId);
            DefaultServerHandlerFactory.FunctionHandlerFactory factory = new DefaultServerHandlerFactory.FunctionHandlerFactory();
            SapJCoServer sapJCoServer = new SapJCoServer(server, connection, sourceCallback, encoding);
            if (Optional.ofNullable(this.targetFunction).map(String::trim).map(String::isEmpty).orElse(true).booleanValue()) {
                factory.registerGenericHandler((Object)sapJCoServer);
            } else {
                factory.registerHandler(this.targetFunction, (Object)sapJCoServer);
            }
            server.setCallHandlerFactory((JCoServerCallHandlerFactory)factory);
            return sapJCoServer;
        }
        catch (JCoException e) {
            SapJCoDataProvider.getInstance().deleteServer(programId);
            throw new SapServerInitializationException(programId, e);
        }
    }
}

