/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.sap.extension.internal.source.server.builder;

import java.io.InputStream;
import java.util.Properties;
import org.mule.modules.sap.extension.api.SapAttributes;
import org.mule.modules.sap.extension.internal.connection.SapConnection;
import org.mule.modules.sap.extension.internal.connection.SapJCoDataProvider;
import org.mule.modules.sap.extension.internal.source.server.SapJCoServer;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;

public abstract class SapServerBuilder {
    private final String programId;
    private final SourceCallback<InputStream, SapAttributes> sourceCallback;
    private final String encoding;
    private final SapConnection connection;
    private String gatewayHost;
    private String gatewayService;
    private Integer connectionCount;

    public SapServerBuilder(SapConnection connection, String programId, String encoding, SourceCallback<InputStream, SapAttributes> sourceCallback) {
        this.connection = connection;
        this.programId = programId;
        this.encoding = encoding;
        this.sourceCallback = sourceCallback;
    }

    public SapServerBuilder withGatewayHost(String gatewayHost) {
        this.gatewayHost = gatewayHost;
        return this;
    }

    public SapServerBuilder withGatewayService(String gatewayService) {
        this.gatewayService = gatewayService;
        return this;
    }

    public SapServerBuilder withConnectionCount(Integer connectionCount) {
        this.connectionCount = connectionCount;
        return this;
    }

    public SapJCoServer create() {
        Properties properties = new Properties();
        properties.put("jco.server.gwhost", this.gatewayHost);
        properties.put("jco.server.gwserv", this.gatewayService);
        properties.put("jco.server.progid", this.programId);
        properties.put("jco.server.connection_count", this.connectionCount.toString());
        properties.put("jco.server.repository_destination", this.connection.getKey());
        SapJCoDataProvider.getInstance().addServer(this.programId, properties);
        return this.create(this.connection, this.programId, this.encoding, this.sourceCallback);
    }

    protected abstract SapJCoServer create(SapConnection var1, String var2, String var3, SourceCallback<InputStream, SapAttributes> var4);
}

