/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.analytics.internal.connection.provider;

import com.sforce.soap.partner.PartnerConnection;
import org.mule.modules.salesforce.analytics.internal.connection.ConnectionServiceFactory;
import org.mule.modules.salesforce.analytics.internal.connection.SalesforceAnalyticsConnection;
import org.mule.modules.salesforce.analytics.internal.connection.param.AdvancedParams;
import org.mule.modules.salesforce.analytics.internal.connection.param.BasicAuthUserPassParams;
import org.mule.modules.salesforce.analytics.internal.connection.param.ProxySettingsParams;
import org.mule.modules.salesforce.analytics.internal.connection.param.bundle.ParamsBundle;
import org.mule.modules.salesforce.analytics.internal.connection.provider.AbstractConnectionProvider;
import org.mule.modules.salesforce.analytics.internal.connection.service.BasicConnectionService;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.sdk.api.annotation.semantics.connectivity.BasicAuth;
import org.mule.sdk.api.annotation.semantics.connectivity.ExcludeFromConnectivitySchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="basic")
@DisplayName(value="Username Password")
@BasicAuth
public class BasicConnectionProvider
extends AbstractConnectionProvider
implements Initialisable {
    private static final Logger logger = LoggerFactory.getLogger(BasicConnectionProvider.class);
    @Parameter
    @Placement(tab="Security", order=1)
    @DisplayName(value="TLS configuration")
    @Summary(value="If the HTTPS was configured as protocol, then the user needs to configure at least the keystore configuration")
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ExcludeFromConnectivitySchema
    protected TlsContextFactory tlsContextFactory;
    @ParameterGroup(name="Connection")
    @Placement(order=1)
    private BasicAuthUserPassParams basicAuthUserPassParams;
    @ParameterGroup(name="Advanced")
    @Placement(order=2)
    private AdvancedParams connectionAdvancedParamsWithSession;
    @ParameterGroup(name="Proxy")
    @Placement(order=4)
    private ProxySettingsParams proxySettingsParams;
    private ConnectionServiceFactory connectionServiceFactory = new ConnectionServiceFactory();

    public SalesforceAnalyticsConnection connect() throws ConnectionException {
        ParamsBundle bundle = new ParamsBundle(this.tlsContextFactory, this.getSslContext(this.tlsContextFactory));
        bundle.setConnectionAuthParams(this.basicAuthUserPassParams);
        bundle.setConnectionAdvancedParamsWithSession(this.connectionAdvancedParamsWithSession);
        bundle.setProxySettingsParams(this.proxySettingsParams);
        BasicConnectionService basicConnectionService = this.connectionServiceFactory.basicConnectionService();
        PartnerConnection partnerConnection = basicConnectionService.login(bundle, new BasicConnectionService.SessionRenewerHandler());
        SalesforceAnalyticsConnection salesforceAnalyticsConnection = new SalesforceAnalyticsConnection(partnerConnection, null);
        logger.info("Connection established.SessionID: {}", (Object)salesforceAnalyticsConnection.getPartnerConnection().getConfig().getSessionId());
        return salesforceAnalyticsConnection;
    }

    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded((Object)this.tlsContextFactory);
    }

    public void setBasicAuthUserPassParams(BasicAuthUserPassParams basicAuthUserPassParams) {
        this.basicAuthUserPassParams = basicAuthUserPassParams;
    }

    public void setConnectionAdvancedParamsWithSession(AdvancedParams connectionAdvancedParamsWithSession) {
        this.connectionAdvancedParamsWithSession = connectionAdvancedParamsWithSession;
    }

    public void setProxySettingsParams(ProxySettingsParams proxySettingsParams) {
        this.proxySettingsParams = proxySettingsParams;
    }
}

