/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.analytics.internal.connection.provider;

import com.sforce.soap.partner.PartnerConnection;
import org.mule.modules.salesforce.analytics.internal.connection.param.OAuth2TokenBearerWithAudienceParams;
import org.mule.modules.salesforce.analytics.internal.connection.param.bundle.OAuth2TokenBearerParamsWithAudienceBundle;
import org.mule.modules.salesforce.analytics.internal.connection.provider.AbstractOAuthBearerConnectionProvider;
import org.mule.modules.salesforce.analytics.internal.connection.service.GrantType;
import org.mule.modules.salesforce.analytics.internal.connection.service.OAuthTokenBearerService;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;

@Alias(value="oauth-jwt")
@DisplayName(value="OAuth JWT")
public class OAuthJWTConnectionProvider
extends AbstractOAuthBearerConnectionProvider {
    @ParameterGroup(name="Connection")
    @Placement(order=1)
    private OAuth2TokenBearerWithAudienceParams oAuth2TokenBearerWithAudienceParams;

    @Override
    public PartnerConnection createPartnerConnection() throws ConnectionException {
        OAuth2TokenBearerParamsWithAudienceBundle oAuth2TokenBearerParamsWithAudienceBundle = new OAuth2TokenBearerParamsWithAudienceBundle(this.tlsContextFactory, this.getSslContext(this.tlsContextFactory));
        oAuth2TokenBearerParamsWithAudienceBundle.setoAuth2TokenBearerWithAudienceParams(this.oAuth2TokenBearerWithAudienceParams);
        oAuth2TokenBearerParamsWithAudienceBundle.setoAuthAdvancedParams(this.oAuthAdvancedParams);
        oAuth2TokenBearerParamsWithAudienceBundle.setProxySettingsParams(this.proxySettingsParams);
        OAuthTokenBearerService oAuthTokenBearerService = this.connectionServiceFactory.oAuthTokenBearerService(this.httpService, oAuth2TokenBearerParamsWithAudienceBundle);
        return oAuthTokenBearerService.login(GrantType.JWT);
    }

    public OAuth2TokenBearerWithAudienceParams getoAuth2TokenBearerWithAudienceParams() {
        return this.oAuth2TokenBearerWithAudienceParams;
    }

    public void setoAuth2TokenBearerWithAudienceParams(OAuth2TokenBearerWithAudienceParams oAuth2TokenBearerWithAudienceParams) {
        this.oAuth2TokenBearerWithAudienceParams = oAuth2TokenBearerWithAudienceParams;
    }
}

