/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.analytics.internal.connection.service;

import com.sforce.soap.partner.PartnerConnection;
import java.net.URI;
import java.net.URISyntaxException;
import org.mule.runtime.api.connection.ConnectionException;

public class AbstractConnectionService {
    protected void switchEndpointToMutualTlsIfNeeded(PartnerConnection partnerConnection) throws ConnectionException {
        if (partnerConnection.getConfig().getSslContext() != null) {
            partnerConnection.getConfig().setServiceEndpoint(this.buildMutualTLSEndpoint(partnerConnection.getConfig().getServiceEndpoint()));
            partnerConnection.getConfig().setRestEndpoint(this.buildMutualTLSEndpoint(partnerConnection.getConfig().getRestEndpoint()));
        }
    }

    private String buildMutualTLSEndpoint(String endpoint) throws ConnectionException {
        if (endpoint == null) {
            return null;
        }
        try {
            URI uri = new URI(endpoint);
            return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), 8443, uri.getPath(), uri.getQuery(), uri.getFragment()).toString();
        }
        catch (URISyntaxException e) {
            throw new ConnectionException(e.getMessage(), (Throwable)e);
        }
    }
}

