/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.analytics.internal.connection.service;

import com.google.gson.Gson;
import com.sforce.soap.partner.PartnerConnection;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import org.mule.modules.salesforce.analytics.internal.connection.param.OAuth2TokenBearerParams;
import org.mule.modules.salesforce.analytics.internal.connection.param.OAuth2TokenBearerWithAudienceParams;
import org.mule.modules.salesforce.analytics.internal.connection.param.bundle.BaseOAuthParamsBundle;
import org.mule.modules.salesforce.analytics.internal.connection.param.bundle.OAuth2TokenBearerParamsBundle;
import org.mule.modules.salesforce.analytics.internal.connection.param.bundle.OAuth2TokenBearerParamsWithAudienceBundle;
import org.mule.modules.salesforce.analytics.internal.connection.service.AbstractOAuthConnectionService;
import org.mule.modules.salesforce.analytics.internal.connection.service.GrantType;
import org.mule.modules.salesforce.analytics.internal.connection.service.HttpClientService;
import org.mule.modules.salesforce.analytics.internal.connection.service.OAuthTokenGeneratorService;
import org.mule.modules.salesforce.analytics.internal.error.AnalyticsErrorType;
import org.mule.modules.salesforce.analytics.internal.error.exception.AnalyticsException;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.http.api.client.HttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthTokenBearerService
extends AbstractOAuthConnectionService {
    private static final Logger logger = LoggerFactory.getLogger(OAuthTokenBearerService.class);
    private static final Gson OBJECT_MAPPER = new Gson();
    private static final String ACCESS_TOKEN_PROPERTY = "access_token";
    private static final String INSTANCE_URL_PROPERTY = "instance_url";
    private OAuthTokenGeneratorService oAuthTokenGeneratorService;
    private HttpClient httpClient;
    BaseOAuthParamsBundle baseOAuthParamsBundle;

    public OAuthTokenBearerService(HttpClient httpClient, BaseOAuthParamsBundle baseOAuthParamsBundle) {
        this.httpClient = httpClient;
        this.httpClient.start();
        this.baseOAuthParamsBundle = baseOAuthParamsBundle;
        this.oAuthTokenGeneratorService = new OAuthTokenGeneratorService();
    }

    public PartnerConnection login(GrantType grantType) throws ConnectionException {
        InputStream keyStoreStream = null;
        try {
            String token;
            OAuth2TokenBearerParams oAuth2TokenBearerParams = null;
            oAuth2TokenBearerParams = this.baseOAuthParamsBundle instanceof OAuth2TokenBearerParamsBundle ? ((OAuth2TokenBearerParamsBundle)this.baseOAuthParamsBundle).getoAuth2TokenBearerParams() : ((OAuth2TokenBearerParamsWithAudienceBundle)this.baseOAuthParamsBundle).getoAuth2TokenBearerWithAudienceParams();
            keyStoreStream = this.getKeyStoreResourceStream(oAuth2TokenBearerParams.getKeyStore());
            String tokenEndpointBaseUrl = this.computeBaseUrl(oAuth2TokenBearerParams.getTokenEndpoint());
            switch (grantType) {
                case JWT: {
                    token = this.oAuthTokenGeneratorService.generateJWTToken(oAuth2TokenBearerParams.getConsumerKey(), oAuth2TokenBearerParams.getPrincipal(), Optional.ofNullable(((OAuth2TokenBearerWithAudienceParams)oAuth2TokenBearerParams).getAudienceUrl()).orElseGet(() -> tokenEndpointBaseUrl), keyStoreStream, oAuth2TokenBearerParams.getStorePassword() != null ? oAuth2TokenBearerParams.getStorePassword().toCharArray() : null);
                    break;
                }
                case SAML: {
                    token = this.oAuthTokenGeneratorService.generateSAMLToken(oAuth2TokenBearerParams.getConsumerKey(), oAuth2TokenBearerParams.getPrincipal(), tokenEndpointBaseUrl, oAuth2TokenBearerParams.getTokenEndpoint(), keyStoreStream, oAuth2TokenBearerParams.getStorePassword() != null ? oAuth2TokenBearerParams.getStorePassword().toCharArray() : null);
                    break;
                }
                default: {
                    throw new AnalyticsException("Please try again and if the error persists then contact support", AnalyticsErrorType.CONNECTIVITY);
                }
            }
            Map<String, String> result = this.sendAuthorizationRequestAndParseResponse(oAuth2TokenBearerParams, grantType.getUrn(), token, this.httpClient);
            PartnerConnection partnerConnection = this.postAuthorization(this.baseOAuthParamsBundle, result.get(ACCESS_TOKEN_PROPERTY), result.get(INSTANCE_URL_PROPERTY));
            return partnerConnection;
        }
        catch (FileNotFoundException e) {
            throw new AnalyticsException("Failed establishing connection with salesforce", AnalyticsErrorType.CONNECTIVITY, e);
        }
        finally {
            if (this.httpClient != null) {
                this.httpClient.stop();
            }
            if (keyStoreStream != null) {
                try {
                    keyStoreStream.close();
                }
                catch (IOException e) {
                    logger.error("Failed closing key store stream", (Throwable)e);
                }
            }
        }
    }

    private InputStream getKeyStoreResourceStream(String keyStoreName) throws FileNotFoundException {
        Path filePath = Paths.get(keyStoreName, new String[0]);
        InputStream keyStoreStream = filePath.isAbsolute() ? new FileInputStream(keyStoreName) : Thread.currentThread().getContextClassLoader().getResourceAsStream(keyStoreName);
        return keyStoreStream;
    }

    private String computeBaseUrl(String url) {
        String baseUrl;
        try {
            String path = new URL(url).getPath();
            baseUrl = url.substring(0, url.indexOf(path));
        }
        catch (MalformedURLException e) {
            throw new AnalyticsException("Invalid URL: " + url, AnalyticsErrorType.UNKNOWN, e);
        }
        return baseUrl;
    }

    private Map<String, String> sendAuthorizationRequestAndParseResponse(OAuth2TokenBearerParams oAuth2TokenBearerParams, String grantType, String token, HttpClient httpClient) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        headers.put("charset", "UTF-8");
        headers.put("Accept-Encoding", "gzip");
        StringBuilder requestBody = new StringBuilder();
        requestBody.append("grant_type").append("=").append(grantType).append("&").append("assertion").append("=").append(token);
        try {
            HttpClientService httpClientService = new HttpClientService(httpClient);
            InputStream responseStream = httpClientService.sendPost(oAuth2TokenBearerParams.getTokenEndpoint(), requestBody.toString(), headers, null);
            return (Map)OBJECT_MAPPER.fromJson(IOUtils.toString((InputStream)responseStream), Map.class);
        }
        catch (IOException | TimeoutException e) {
            throw new AnalyticsException(e.getMessage(), AnalyticsErrorType.CONNECTIVITY, e);
        }
    }
}

