/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.analytics.internal.operation;

import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.mule.modules.salesforce.analytics.api.DataSet;
import org.mule.modules.salesforce.analytics.internal.config.SalesforceAnalyticsConfig;
import org.mule.modules.salesforce.analytics.internal.connection.SalesforceAnalyticsConnection;
import org.mule.modules.salesforce.analytics.internal.error.provider.AnalyticsErrorTypeProvider;
import org.mule.modules.salesforce.analytics.internal.metadata.SalesforceAnalyticsMetadataResolver;
import org.mule.modules.salesforce.analytics.internal.operation.AnalyticsOperations;
import org.mule.modules.salesforce.analytics.internal.service.SalesforceAnalyticsService;
import org.mule.modules.salesforce.analytics.internal.service.impl.SalesforceAnalyticsServiceImpl;
import org.mule.runtime.api.bulk.BulkOperationResult;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.meta.model.display.PathModel;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.Path;

@Throws(value={AnalyticsErrorTypeProvider.class})
public class SalesforceAnalyticsOperations
extends AnalyticsOperations<SalesforceAnalyticsService> {
    @Inject
    @Named(value="_muleObjectStoreManager")
    private ObjectStoreManager objectStoreManager;
    @Inject
    @Named(value="_muleLockFactory")
    private LockFactory lockFactory;

    public SalesforceAnalyticsOperations() {
        super(SalesforceAnalyticsServiceImpl::new);
    }

    @MediaType(value="*/*")
    public String createDataSet(@Config SalesforceAnalyticsConfig config, @Connection SalesforceAnalyticsConnection connection, @Path(type=PathModel.Type.FILE) String type, @ParameterGroup(name="DataSet info") DataSet dataSetInfo) {
        return (String)this.newExecutionBuilder(config, connection).execute(SalesforceAnalyticsService::createDataSet).withParam((Object)type).withParam((Object)dataSetInfo).withParam((Object)this.objectStoreManager);
    }

    public BulkOperationResult<Map<String, String>> uploadExternalData(@Config SalesforceAnalyticsConfig config, @Connection SalesforceAnalyticsConnection connection, @MetadataKeyId(value=SalesforceAnalyticsMetadataResolver.class) String dataSetId, @Content @TypeResolver(value=SalesforceAnalyticsMetadataResolver.class) List<Map<String, Object>> records) {
        return (BulkOperationResult)this.newExecutionBuilder(config, connection).execute(SalesforceAnalyticsService::uploadExternalData).withParam(records).withParam((Object)dataSetId).withParam((Object)this.lockFactory).withParam((Object)this.objectStoreManager);
    }

    public void startDataProcessing(@Config SalesforceAnalyticsConfig config, @Connection SalesforceAnalyticsConnection connection, @MetadataKeyId(value=SalesforceAnalyticsMetadataResolver.class) String dataSetId) {
        this.newExecutionBuilder(config, connection).execute(SalesforceAnalyticsService::startDataProcessing).withParam((Object)dataSetId);
    }

    @MediaType(value="*/*")
    public String uploadExternalDataIntoNewDataSetAndStartProcessing(@Config SalesforceAnalyticsConfig config, @Connection SalesforceAnalyticsConnection connection, @Path(type=PathModel.Type.FILE) String type, @ParameterGroup(name="DataSet info") DataSet dataSetInfo, @Content List<Map<String, Object>> records) {
        String dataSetId = this.createDataSet(config, connection, type, dataSetInfo);
        this.uploadExternalData(config, connection, dataSetId, records);
        this.startDataProcessing(config, connection, dataSetId);
        return dataSetId;
    }

    public void deleteDataSet(@Config SalesforceAnalyticsConfig config, @Connection SalesforceAnalyticsConnection connection, @MetadataKeyId(value=SalesforceAnalyticsMetadataResolver.class) String dataSetId) {
        this.newExecutionBuilder(config, connection).execute(SalesforceAnalyticsService::deleteDataSet).withParam((Object)dataSetId);
    }
}

