/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.analytics.internal.service.impl;

import com.google.gson.Gson;
import com.sforce.ws.ConnectionException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import org.mule.connectors.commons.template.config.ConnectorConfig;
import org.mule.connectors.commons.template.connection.ConnectorConnection;
import org.mule.connectors.commons.template.service.DefaultConnectorService;
import org.mule.modules.salesforce.analytics.api.DataSet;
import org.mule.modules.salesforce.analytics.internal.config.SalesforceAnalyticsConfig;
import org.mule.modules.salesforce.analytics.internal.connection.SalesforceAnalyticsConnection;
import org.mule.modules.salesforce.analytics.internal.dto.RecordProcessResultDTO;
import org.mule.modules.salesforce.analytics.internal.error.AnalyticsErrorType;
import org.mule.modules.salesforce.analytics.internal.error.exception.AnalyticsException;
import org.mule.modules.salesforce.analytics.internal.error.exception.MetadataException;
import org.mule.modules.salesforce.analytics.internal.error.exception.WriterException;
import org.mule.modules.salesforce.analytics.internal.metadata.AnalyticsMetadataInfo;
import org.mule.modules.salesforce.analytics.internal.metadata.Format;
import org.mule.modules.salesforce.analytics.internal.service.SalesforceAnalyticsService;
import org.mule.modules.salesforce.analytics.internal.service.transaction.AnalyticsTransactionManagerImpl;
import org.mule.modules.salesforce.analytics.internal.service.transaction.TransactionManager;
import org.mule.modules.salesforce.analytics.internal.util.AnalyticsOutputStream;
import org.mule.modules.salesforce.analytics.internal.util.MetadataUtil;
import org.mule.modules.salesforce.analytics.internal.util.csv.CSVOutputWriter;
import org.mule.modules.salesforce.analytics.internal.util.csv.CollectionOfMapReader;
import org.mule.runtime.api.bulk.BulkItem;
import org.mule.runtime.api.bulk.BulkOperationResult;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.api.store.ObjectStoreSettings;

public final class SalesforceAnalyticsServiceImpl
extends DefaultConnectorService<SalesforceAnalyticsConfig, SalesforceAnalyticsConnection>
implements SalesforceAnalyticsService {
    private static final Gson OBJECT_MAPPER = new Gson();
    private TransactionManager transactionManager;

    public SalesforceAnalyticsServiceImpl(SalesforceAnalyticsConfig config, SalesforceAnalyticsConnection connection) {
        super((ConnectorConfig)config, (ConnectorConnection)connection);
        this.transactionManager = new AnalyticsTransactionManagerImpl(connection);
    }

    @Override
    public String createDataSet(String type, DataSet dataSetInfo, ObjectStoreManager objectStoreManager) throws MetadataException, WriterException, IOException {
        AnalyticsMetadataInfo analyticsMetadataInfo = MetadataUtil.loadMetadataFromFile(type);
        String metadataJson = OBJECT_MAPPER.toJson((Object)analyticsMetadataInfo);
        String dataSetId = this.transactionManager.create(dataSetInfo.getDataSetName(), metadataJson, Format.CSV.getName(), dataSetInfo.getOperation(), dataSetInfo.getEdgemartContainer(), dataSetInfo.getNotificationSent(), dataSetInfo.getNotificationEmail(), dataSetInfo.getMode());
        CSVOutputWriter outputStreamWriter = new CSVOutputWriter(analyticsMetadataInfo);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        outputStreamWriter.initStream(byteArrayOutputStream);
        int partNo = 1;
        this.transactionManager.sendDataPart(dataSetId, byteArrayOutputStream.toByteArray(), partNo, this.getPartNumberObjectStore(objectStoreManager));
        return dataSetId;
    }

    @Override
    public BulkOperationResult<Map<String, String>> uploadExternalData(List<Map<String, Object>> payload, String dataSetId, LockFactory lockFactory, ObjectStoreManager objectStoreManager) throws MetadataException, WriterException, IOException {
        AnalyticsMetadataInfo analyticsMetadataInfo;
        try {
            analyticsMetadataInfo = MetadataUtil.getAnalyticsMetadata((SalesforceAnalyticsConnection)this.getConnection(), dataSetId);
        }
        catch (ConnectionException e) {
            throw new AnalyticsException(AnalyticsErrorType.CONNECTIVITY, e);
        }
        AnalyticsOutputStream outputStream = this.getAnalyticsOutputStream(dataSetId, lockFactory, objectStoreManager);
        CSVOutputWriter outputStreamWriter = new CSVOutputWriter(analyticsMetadataInfo);
        CollectionOfMapReader collectionOfMapReader = new CollectionOfMapReader(payload, MetadataUtil.mapMetadata(analyticsMetadataInfo.getObjects().get(0)));
        List<RecordProcessResultDTO> recordProcessResults = outputStreamWriter.writeData(outputStream, collectionOfMapReader);
        outputStream.close();
        return SalesforceAnalyticsServiceImpl.computeBulkOperationResult(recordProcessResults);
    }

    @Override
    public void startDataProcessing(String dataSetId) {
        this.transactionManager.commit(dataSetId);
    }

    @Override
    public void deleteDataSet(String dataSetId) {
        this.transactionManager.delete(dataSetId);
    }

    public static BulkOperationResult<Map<String, String>> computeBulkOperationResult(List<RecordProcessResultDTO> recordProcessResults) {
        BulkOperationResult.BulkOperationResultBuilder builder = BulkOperationResult.builder();
        for (RecordProcessResultDTO recordProcessResult : recordProcessResults) {
            BulkItem.BulkItemBuilder<Map<String, String>> bulkItemBuilder = SalesforceAnalyticsServiceImpl.computeBulkItem(recordProcessResult);
            builder.addItem(bulkItemBuilder);
        }
        return builder.build();
    }

    private static BulkItem.BulkItemBuilder<Map<String, String>> computeBulkItem(RecordProcessResultDTO recordProcessResult) {
        BulkItem.BulkItemBuilder bulkItemBuilder = BulkItem.builder();
        bulkItemBuilder.setException(recordProcessResult.getException());
        bulkItemBuilder.setSuccessful(recordProcessResult.isSuccessful());
        bulkItemBuilder.setMessage(recordProcessResult.getDetailMessage());
        bulkItemBuilder.setStatusCode(recordProcessResult.getStatusCode());
        bulkItemBuilder.setPayload(recordProcessResult.getPayload());
        return bulkItemBuilder;
    }

    private ObjectStore<Integer> getPartNumberObjectStore(ObjectStoreManager objectStoreManager) {
        return objectStoreManager.getOrCreateObjectStore("partNoObjectStore", ObjectStoreSettings.builder().persistent(true).maxEntries(Integer.valueOf(0)).entryTtl(Long.valueOf(0L)).expirationInterval(Long.valueOf(0L)).build());
    }

    private AnalyticsOutputStream getAnalyticsOutputStream(String dataSetId, LockFactory lockFactory, ObjectStoreManager objectStoreManager) {
        ObjectStore<Integer> partNoObjectStore = this.getPartNumberObjectStore(objectStoreManager);
        Lock partUploadLock = lockFactory.createLock("partNoLock");
        return new AnalyticsOutputStream(dataSetId, 0xA00000, this.transactionManager, (SalesforceAnalyticsConnection)this.getConnection(), partNoObjectStore, partUploadLock);
    }
}

