/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.analytics.internal.util;

import com.sforce.ws.ConnectorConfig;
import com.sforce.ws.MessageHandler;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.mule.modules.salesforce.analytics.internal.connection.ProxyAuthenticator;
import org.mule.modules.salesforce.analytics.internal.connection.param.AdvancedParams;
import org.mule.modules.salesforce.analytics.internal.connection.param.ProxySettingsParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionUtil {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionUtil.class);

    private ConnectionUtil() {
    }

    public static void enrichWithProxyConfig(ConnectorConfig connectorConfig, ProxySettingsParams proxySettingsParams) {
        if (proxySettingsParams != null && StringUtils.isNotBlank((CharSequence)proxySettingsParams.getProxyHost())) {
            if (StringUtils.isNotBlank((CharSequence)proxySettingsParams.getProxyUsername()) && StringUtils.isNotBlank((CharSequence)proxySettingsParams.getProxyPassword())) {
                ProxyAuthenticator proxyAuthenticator = new ProxyAuthenticator(proxySettingsParams.getProxyUsername(), proxySettingsParams.getProxyPassword());
                Authenticator.setDefault(proxyAuthenticator);
                Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxySettingsParams.getProxyHost(), (int)proxySettingsParams.getProxyPort()));
                connectorConfig.setProxy(proxy);
            } else {
                connectorConfig.setProxy(proxySettingsParams.getProxyHost(), proxySettingsParams.getProxyPort().intValue());
            }
        }
    }

    public static void enrichWithConnectionConfig(ConnectorConfig connectorConfig, AdvancedParams authAdvancedParams) {
        if (authAdvancedParams != null) {
            if (authAdvancedParams.getConnectionTimeout() != null) {
                connectorConfig.setConnectionTimeout((int)authAdvancedParams.getReadTimeoutTimeUnit().toMillis(authAdvancedParams.getConnectionTimeout().intValue()));
            }
            if (authAdvancedParams.getReadTimeout() != null) {
                connectorConfig.setReadTimeout((int)authAdvancedParams.getReadTimeoutTimeUnit().toMillis(authAdvancedParams.getReadTimeout().intValue()));
            }
        }
        if (logger.isDebugEnabled()) {
            connectorConfig.addMessageHandler(new MessageHandler(){

                public void handleRequest(URL endpoint, byte[] request) {
                    logger.debug("Sending request to {}", (Object)endpoint);
                    logger.debug(new String(request, StandardCharsets.UTF_8));
                }

                public void handleResponse(URL endpoint, byte[] response) {
                    logger.debug("Receiving response from {}", (Object)endpoint);
                    logger.debug(new String(response, StandardCharsets.UTF_8));
                }
            });
        }
    }
}

