/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.analytics.internal.util.csv;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.modules.salesforce.analytics.internal.dto.RecordProcessResultDTO;
import org.mule.modules.salesforce.analytics.internal.error.exception.ReaderException;
import org.mule.modules.salesforce.analytics.internal.error.exception.WriterException;
import org.mule.modules.salesforce.analytics.internal.metadata.AnalyticsMetadataInfo;
import org.mule.modules.salesforce.analytics.internal.metadata.FieldMetadata;
import org.mule.modules.salesforce.analytics.internal.metadata.FileFormat;
import org.mule.modules.salesforce.analytics.internal.util.csv.CollectionOfMapReader;
import org.mule.modules.salesforce.analytics.internal.util.csv.MapToCSVLineTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVOutputWriter {
    private static final Logger logger = LoggerFactory.getLogger(CSVOutputWriter.class);
    private AnalyticsMetadataInfo analyticsMetadataInfo;
    private Set<String> orderOfHeaders;
    private FileFormat fileFormat;

    public CSVOutputWriter(AnalyticsMetadataInfo analyticsMetadataInfo) {
        this.analyticsMetadataInfo = analyticsMetadataInfo;
        this.fileFormat = analyticsMetadataInfo.getFileFormat();
        this.orderOfHeaders = this.computeHeaderOrder(analyticsMetadataInfo);
    }

    public void initStream(OutputStream dataOutputStream) throws WriterException {
        this.checkExistenceOfHeaderOrder();
        this.checkExistenceOfFileFormat();
        String headerLine = this.getHeaderLine();
        try {
            dataOutputStream.write(headerLine.getBytes("UTF-8"));
            dataOutputStream.write(this.fileFormat.getLinesTerminatedBy().getBytes("UTF-8"));
        }
        catch (IOException e) {
            throw new WriterException(e.getMessage());
        }
    }

    private void checkExistenceOfHeaderOrder() throws WriterException {
        if (this.orderOfHeaders == null || this.orderOfHeaders.isEmpty()) {
            throw new WriterException("Header order is missing.");
        }
    }

    private void checkExistenceOfFileFormat() throws WriterException {
        if (this.fileFormat == null) {
            throw new WriterException("File format is missing.");
        }
    }

    private Map<String, FieldMetadata> getMappings() {
        HashMap<String, FieldMetadata> mappings = new HashMap<String, FieldMetadata>();
        for (FieldMetadata fieldMetadata : this.analyticsMetadataInfo.getObjects().get(0).getFields()) {
            mappings.put(fieldMetadata.getName(), fieldMetadata);
        }
        return mappings;
    }

    private String getHeaderLine() {
        StringBuilder headerLine = new StringBuilder();
        int index = 0;
        for (String headerName : this.orderOfHeaders) {
            headerLine.append(headerName);
            if (index < this.orderOfHeaders.size() - 1) {
                headerLine.append(this.fileFormat.getFieldsDelimitedBy());
            }
            ++index;
        }
        return headerLine.toString();
    }

    private synchronized void writeRecord(String recordToWrite, OutputStream outputStream) throws WriterException {
        try {
            logger.debug("Writing record: {} to stream.", (Object)recordToWrite);
            outputStream.write(recordToWrite.getBytes("UTF-8"));
        }
        catch (IOException e) {
            throw new WriterException(e.getMessage());
        }
    }

    public List<RecordProcessResultDTO> writeData(OutputStream outputStream, CollectionOfMapReader genericReader) throws WriterException {
        this.checkExistenceOfHeaderOrder();
        this.checkExistenceOfFileFormat();
        ArrayList<RecordProcessResultDTO> recordProcessResults = new ArrayList<RecordProcessResultDTO>();
        genericReader.readHeaderNames();
        MapToCSVLineTransformer transformer = new MapToCSVLineTransformer(this.orderOfHeaders, this.fileFormat, this.getMappings());
        while (genericReader.ready()) {
            recordProcessResults.add(this.processRecord(genericReader, transformer, outputStream));
        }
        return recordProcessResults;
    }

    private RecordProcessResultDTO processRecord(CollectionOfMapReader genericReader, MapToCSVLineTransformer transformer, OutputStream outputStream) {
        RecordProcessResultDTO recordProcessResult;
        Map<String, String> valuesMap = null;
        try {
            genericReader.readRecord();
            valuesMap = genericReader.getRecord();
            this.writeRecord(transformer.transformRecord(valuesMap) + "\n", outputStream);
            recordProcessResult = this.getRecordProcessResult(true, null, null, null, valuesMap);
        }
        catch (WriterException e) {
            recordProcessResult = this.getRecordProcessResult(false, "Failed processing record.", e, null, valuesMap);
            logger.error("Failed processing record: {}", valuesMap, (Object)e);
        }
        catch (ReaderException e) {
            recordProcessResult = this.getRecordProcessResult(false, "Failed reading record.", e, null, null);
            logger.error("Failed reading record.", (Throwable)e);
        }
        return recordProcessResult;
    }

    private RecordProcessResultDTO getRecordProcessResult(boolean successful, String detailMessage, Exception exception, String statusCode, Map<String, String> payload) {
        RecordProcessResultDTO recordProcessResult = new RecordProcessResultDTO();
        recordProcessResult.setSuccessful(successful);
        recordProcessResult.setDetailMessage(detailMessage);
        recordProcessResult.setException(exception);
        recordProcessResult.setStatusCode(statusCode);
        recordProcessResult.setPayload(payload);
        return recordProcessResult;
    }

    private Set<String> computeHeaderOrder(AnalyticsMetadataInfo analyticsMetadataInfo) {
        return analyticsMetadataInfo.getObjects().get(0).getFields().stream().map(FieldMetadata::getName).filter(Objects::nonNull).collect(Collectors.toCollection(LinkedHashSet::new));
    }
}

