/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.salesforce.analytics.internal.util.csv;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mule.modules.salesforce.analytics.internal.error.exception.ReaderException;
import org.mule.modules.salesforce.analytics.internal.metadata.DataType;
import org.mule.modules.salesforce.analytics.internal.metadata.FieldMetadata;

public class CollectionOfMapReader {
    private Iterator<Map<String, Object>> collectionIterator;
    private Map<String, FieldMetadata> mappings;
    private Map<String, String> currentRecord;
    private List<String> headerNames;
    private Collection<Map<String, Object>> maps;

    public CollectionOfMapReader(Collection<Map<String, Object>> maps, Map<String, FieldMetadata> mappings) {
        if (mappings == null) {
            throw new NullPointerException();
        }
        this.maps = maps;
        this.collectionIterator = maps.iterator();
        this.mappings = mappings;
    }

    public void readHeaderNames() {
        this.headerNames = new ArrayList<String>(this.maps.iterator().next().keySet());
    }

    public List<String> getHeaderNames() {
        return this.headerNames;
    }

    public void skipRecords(long n) {
        int i = 0;
        while ((long)i++ < n && this.ready()) {
            this.collectionIterator.next();
        }
    }

    public void readRecord() throws ReaderException {
        this.currentRecord = this.extractFieldValuesFromGenericMap(this.collectionIterator.next(), this.mappings);
    }

    public Map<String, String> getRecord() {
        return this.currentRecord;
    }

    public boolean ready() {
        return this.collectionIterator.hasNext();
    }

    private Map<String, String> extractFieldValuesFromGenericMap(Map<String, Object> genericMap, Map<String, FieldMetadata> mappings) throws ReaderException {
        if (genericMap == null) {
            throw new ReaderException("Generic map that has to be written can not be null");
        }
        if (mappings == null) {
            throw new ReaderException("Metadata map can not be null");
        }
        HashMap<String, String> fieldValueByFieldNameMap = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : genericMap.entrySet()) {
            String fieldName = entry.getKey();
            Object value = entry.getValue();
            String fieldValue = CollectionOfMapReader.getStringRepresentationOfValue(value, mappings.get(fieldName));
            fieldValueByFieldNameMap.put(fieldName, fieldValue);
        }
        return fieldValueByFieldNameMap;
    }

    private static String getStringRepresentationOfValue(Object value, FieldMetadata fieldTypeInfo) throws ReaderException {
        String stringRepresentation = null;
        if (value != null && fieldTypeInfo != null) {
            DataType type = fieldTypeInfo.getType();
            if (type == DataType.DATE || type == DataType.DATE_ONLY || type == DataType.DATE_TIME) {
                String format = fieldTypeInfo.getFormat();
                stringRepresentation = CollectionOfMapReader.formatDateObject(value, format);
            } else if (type == DataType.TEXT && fieldTypeInfo.getIsMultiValue() != null && fieldTypeInfo.getIsMultiValue().booleanValue()) {
                String separator = fieldTypeInfo.getMultiValueSeparator();
                stringRepresentation = CollectionOfMapReader.formatListObject(value, separator);
            } else {
                stringRepresentation = value.toString();
            }
        }
        return stringRepresentation;
    }

    private static String formatDateObject(Object object, String format) throws ReaderException {
        if (format == null) {
            throw new ReaderException("Format not provided");
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof LocalDateTime) {
            LocalDateTime dateTime = (LocalDateTime)object;
            return dateTime.format(DateTimeFormatter.ofPattern(format));
        }
        if (object instanceof LocalDate) {
            LocalDate date = (LocalDate)object;
            return date.format(DateTimeFormatter.ofPattern(format));
        }
        if (object instanceof ZonedDateTime) {
            ZonedDateTime zonedDateTime = (ZonedDateTime)object;
            return zonedDateTime.format(DateTimeFormatter.ofPattern(format));
        }
        throw new ReaderException("The given object can not be converted to date");
    }

    public static String formatListObject(Object object, String separator) throws ReaderException {
        StringBuilder formattedList = new StringBuilder();
        if (!(object instanceof Collection)) {
            throw new ReaderException("Object is supposed to be of type list but it is not");
        }
        if (separator == null) {
            throw new ReaderException("Separator not provided");
        }
        Collection objects = (Collection)object;
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            Object element = it.next();
            if (element == null) continue;
            formattedList.append(element);
            if (!it.hasNext()) continue;
            formattedList.append(separator);
        }
        return formattedList.toString();
    }
}

