/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.ws.api.client;

import com.mulesoft.connectors.ws.api.client.WebSocketClientSettings;
import java.util.Collections;
import java.util.Map;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.server.HttpServerProperties;

public class WebSocketRequestBuilder {
    @Parameter
    @Optional
    @Content(primary=true)
    protected MultiMap<String, String> headers = MultiMap.emptyMultiMap();
    @Parameter
    @Optional
    @Content
    @DisplayName(value="URI Parameters")
    private Map<String, String> uriParams = Collections.emptyMap();
    @Parameter
    @Optional
    @Content
    @DisplayName(value="Query Parameters")
    private MultiMap<String, String> queryParams = MultiMap.emptyMultiMap();

    public String replaceUriParams(String path) {
        for (String uriParamName : this.uriParams.keySet()) {
            String uriParamValue = this.uriParams.get(uriParamName);
            if (uriParamValue == null) {
                throw new NullPointerException(String.format("Expression {%s} evaluated to null.", uriParamName));
            }
            path = path.replaceAll("\\{" + uriParamName + "\\}", uriParamValue);
        }
        return path;
    }

    public MultiMap<String, String> getHeaders() {
        return this.headers.toImmutableMultiMap();
    }

    public MultiMap<String, String> getQueryParams() {
        return this.queryParams.toImmutableMultiMap();
    }

    public Map<String, String> getUriParams() {
        return Collections.unmodifiableMap(this.uriParams);
    }

    public HttpRequestBuilder toRequestBuilder(WebSocketClientSettings settings) {
        return ((HttpRequestBuilder)HttpRequest.builder((HttpServerProperties.PRESERVE_HEADER_CASE || settings.isPreserveHeadersCase() ? 1 : 0) != 0).headers(this.headers)).queryParams(this.queryParams);
    }
}

