/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.ws.api.server;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.annotation.param.reference.ConfigReference;

public class WebSocketServerSettings {
    @Parameter
    @Optional(defaultValue="/")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Server Settings")
    @Summary(value="Base path to use for all resources served through this config.")
    private String listenerBasePath;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ConfigReference(name="LISTENER_CONFIG", namespace="HTTP")
    @Placement(tab="Server Settings")
    @Summary(value="Reference to the <http:listener-config> used to expose the inbound endpoint")
    private String listenerConfig;
    @Parameter
    @Optional(defaultValue="15")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Server Settings")
    @Summary(value="Timeout for automatically closing idle WebSockets")
    private Integer idleSocketTimeout = 15;
    @Parameter
    @Optional(defaultValue="MINUTES")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Server Settings")
    @Summary(value="Time unit that qualifies the idleSocketTimeout")
    private TimeUnit idleSocketTimeoutUnit = TimeUnit.MINUTES;

    public long getIdleSocketTimeoutInMillis() {
        return this.idleSocketTimeoutUnit.toMillis(this.idleSocketTimeout.intValue());
    }

    public String getListenerConfig() {
        return this.listenerConfig;
    }

    public String getListenerBasePath() {
        return this.listenerBasePath;
    }

    public Integer getIdleSocketTimeout() {
        return this.idleSocketTimeout;
    }

    public TimeUnit getIdleSocketTimeoutUnit() {
        return this.idleSocketTimeoutUnit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebSocketServerSettings that = (WebSocketServerSettings)o;
        return Objects.equals(this.listenerBasePath, that.listenerBasePath) && Objects.equals(this.listenerConfig, that.listenerConfig) && Objects.equals(this.idleSocketTimeout, that.idleSocketTimeout) && this.idleSocketTimeoutUnit == that.idleSocketTimeoutUnit;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.listenerBasePath, this.listenerConfig, this.idleSocketTimeout, this.idleSocketTimeoutUnit});
    }
}

