/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.ws.internal.connection;

import com.mulesoft.connectors.ws.internal.client.OutboundSocketMessageHandler;
import com.mulesoft.connectors.ws.internal.util.UsesReadWriteLock;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.server.MethodRequestMatcher;
import org.mule.runtime.http.api.server.PathAndMethodRequestMatcher;
import org.mule.runtime.http.api.utils.RequestMatcherRegistry;

public class OutboundSocketListener
extends UsesReadWriteLock {
    private final RequestMatcherRegistry<OutboundSocketMessageHandler> messageHandlers;
    private final Map<String, RequestMatcherRegistry.RequestMatcherRegistryEntry> handlerEntries = new HashMap<String, RequestMatcherRegistry.RequestMatcherRegistryEntry>();

    public OutboundSocketListener(HttpService httpService) {
        this.messageHandlers = httpService.getRequestMatcherRegistryBuilder().build();
    }

    public void addMessageHandler(String path, OutboundSocketMessageHandler handler) {
        this.withWriteLock(() -> {
            PathAndMethodRequestMatcher matcher = PathAndMethodRequestMatcher.builder().path(path).methodRequestMatcher(MethodRequestMatcher.builder().add("GET").build()).build();
            this.handlerEntries.put(path, this.messageHandlers.add(matcher, (Object)handler));
        });
    }

    public Optional<OutboundSocketMessageHandler> getMessageHandler(String path) {
        return (Optional)this.withReadLock(() -> Optional.ofNullable(this.messageHandlers.find("GET", path)));
    }

    public void removeMessageHandler(String path) {
        this.withWriteLock(() -> {
            RequestMatcherRegistry.RequestMatcherRegistryEntry entry = this.handlerEntries.remove(path);
            if (entry != null) {
                entry.remove();
            }
        });
    }
}

