/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.ws.api;

import com.mulesoft.connectors.ws.api.WebSocketAttributes;
import java.net.URI;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.http.api.server.ws.WebSocketRequest;
import org.mule.runtime.http.api.ws.WebSocket;
import org.mule.runtime.http.api.ws.WebSocketProtocol;

public class InboundWebSocketAttributes
extends WebSocketAttributes {
    @Parameter
    private String version;
    @Parameter
    private String localAddress;
    @Parameter
    private String remoteAddress;
    @Parameter
    @Optional
    private Certificate clientCertificate;

    public InboundWebSocketAttributes() {
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setLocalAddress(String localAddress) {
        this.localAddress = localAddress;
    }

    public void setRemoteAddress(String remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public void setClientCertificate(Certificate clientCertificate) {
        this.clientCertificate = clientCertificate;
    }

    public InboundWebSocketAttributes(WebSocket socket, WebSocketRequest request) {
        this(socket.getId(), socket.getType(), socket.getGroups(), request.getRequestUri().getPath(), request.getRequestUri().toString(), request.getScheme(), request.getHttpVersion(), (MultiMap<String, String>)request.getQueryParams(), (MultiMap<String, String>)request.getHeaders(), Collections.emptyMap(), request.getMethod(), InboundWebSocketAttributes.resolveUri(request), request.getClientConnection().getRemoteHostAddress().toString(), request.getServerConnection().getLocalHostAddress().toString(), request.getClientConnection().getClientCertificate());
    }

    private static String resolveUri(WebSocketRequest request) {
        URI uri = request.getRequestUri();
        String queryString = uri.getQuery();
        if (queryString == null) {
            queryString = "";
        }
        return queryString;
    }

    public InboundWebSocketAttributes(String id, WebSocket.WebSocketType type, List<String> groups, String path, String requestUri, WebSocketProtocol scheme, String version, MultiMap<String, String> queryParams, MultiMap<String, String> headers, Map<String, String> uriParams, String method, String queryString, String localAddress, String remoteAddress, Certificate clientCertificate) {
        super(id, type, groups, path, requestUri, scheme, queryParams, headers, uriParams, method, queryString);
        this.version = version;
        this.localAddress = localAddress;
        this.remoteAddress = remoteAddress;
        this.clientCertificate = clientCertificate;
    }

    public String getVersion() {
        return this.version;
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public Certificate getClientCertificate() {
        return this.clientCertificate;
    }
}

