/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.ws.internal.source;

import com.mulesoft.connectors.ws.api.WebSocketAttributes;
import com.mulesoft.connectors.ws.internal.server.ForwardingWebSocketHandler;
import com.mulesoft.connectors.ws.internal.server.OnConnectCallback;
import com.mulesoft.connectors.ws.internal.source.PathSource;
import com.mulesoft.connectors.ws.internal.util.WebSocketUtils;
import java.util.Collections;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.http.api.server.ws.WebSocketRequest;
import org.mule.runtime.http.api.ws.WebSocket;

@Alias(value="on-inbound-connection")
@DisplayName(value="On New Inbound Connection")
@Summary(value="Triggers when an inbound WebSocket connection is established")
@MediaType(value="text/plain")
public class InboundConnectionListener
extends PathSource<String, WebSocketAttributes> {
    public static final String ALIAS = "on-inbound-connection";
    private static final String ELEMENT_DSL = WebSocketUtils.asDSLElement("on-inbound-connection");
    private ForwardingWebSocketHandler socketHandler;
    private OnConnectCallback onConnectCallback;

    public void onStart(SourceCallback<String, WebSocketAttributes> sourceCallback) throws MuleException {
        this.engageFluxCapacitor();
        String resolvedPath = this.resolvePath();
        this.socketHandler = this.fluxCapacitor.getInboundHandler(resolvedPath).orElseThrow(() -> new IllegalStateException(String.format("A %s was defined for path '%s', but no %s is pointing to such path", ELEMENT_DSL, this.path, "inbound-listener")));
        this.onConnectCallback = (socket, request) -> this.onConnection(sourceCallback, socket, request);
        this.socketHandler.getOnConnectionCallbacks().add(this.onConnectCallback);
    }

    public void onStop() {
        if (this.socketHandler != null) {
            this.socketHandler.getOnConnectionCallbacks().remove(this.onConnectCallback);
            this.socketHandler = null;
            this.onConnectCallback = null;
        }
        this.disengageFluxCapacitor();
    }

    private void onConnection(SourceCallback<String, WebSocketAttributes> sourceCallback, WebSocket socket, WebSocketRequest request) {
        WebSocketAttributes attributes = new WebSocketAttributes(socket.getId(), socket.getType(), socket.getGroups(), request.getRequestUri().getPath(), request.getRequestUri().toString(), request.getScheme(), (MultiMap<String, String>)request.getQueryParams(), (MultiMap<String, String>)request.getHeaders(), Collections.emptyMap(), request.getMethod(), request.getRequestUri().getQuery());
        sourceCallback.handle(Result.builder().output((Object)"").attributes((Object)attributes).build());
    }
}

