/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.ws.internal.source;

import com.mulesoft.connectors.ws.api.InboundWebSocketAttributes;
import com.mulesoft.connectors.ws.internal.connection.WebSocketState;
import com.mulesoft.connectors.ws.internal.server.ForwardingWebSocketHandler;
import com.mulesoft.connectors.ws.internal.source.PathSource;
import com.mulesoft.connectors.ws.internal.util.SynchronizedWebSocketDecorator;
import com.mulesoft.connectors.ws.internal.util.WebSocketUtils;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.http.api.server.ws.WebSocketHandler;
import org.mule.runtime.http.api.server.ws.WebSocketHandlerManager;
import org.mule.runtime.http.api.server.ws.WebSocketMessage;
import org.mule.runtime.http.api.utils.MatcherCollisionException;

@Alias(value="inbound-listener")
@MediaType(value="*/*", strict=false)
@DisplayName(value="On New Inbound Message")
@Summary(value="Triggers when a message is received from an inbound WebSocket")
public class InboundMessageListener
extends PathSource<InputStream, InboundWebSocketAttributes>
implements Initialisable,
Disposable {
    public static final String ALIAS = "inbound-listener";
    @Parameter
    @Optional
    @NullSafe
    private List<String> defaultGroups = Collections.emptyList();
    private WebSocketHandlerManager resourceHandler;
    private ForwardingWebSocketHandler webSocketHandler;
    private String resolvedPath;

    public void initialise() throws InitialisationException {
        try {
            this.engageFluxCapacitor();
        }
        catch (ConnectionException e) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)e.getMessage()), (Throwable)e, (Initialisable)this);
        }
        this.webSocketHandler = this.createHandler();
        this.fluxCapacitor.registerInboundHandler(this.resolvedPath, this.webSocketHandler);
        try {
            this.resourceHandler = this.webSocketServer.getHttpServer().addWebSocketHandler((WebSocketHandler)this.webSocketHandler);
        }
        catch (MatcherCollisionException e) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)String.format("A <websocket:%s> for path '%s' already exists", ALIAS, this.path)), (Initialisable)this);
        }
    }

    public void onStart(SourceCallback<InputStream, InboundWebSocketAttributes> sourceCallback) throws MuleException {
        this.webSocketHandler.getOnConnectionCallbacks().add(0, (socket, request) -> {
            InboundWebSocketAttributes attrs = new InboundWebSocketAttributes(socket, request);
            socket = new SynchronizedWebSocketDecorator(socket);
            this.fluxCapacitor.notifyOpen(new WebSocketState(socket, attrs));
            this.fluxCapacitor.subscribeGroups(socket, this.defaultGroups);
        });
        this.webSocketHandler.setMessageHandler(message -> sourceCallback.handle(this.toResult(message)));
        this.webSocketHandler.getOnCloseCallbacks().add(0, (state, closeCode, reason) -> this.fluxCapacitor.notifyClosed(state.getWebSocket(), closeCode, reason, true));
        this.resourceHandler.start();
    }

    public void onStop() {
        if (this.resourceHandler != null) {
            this.resourceHandler.stop();
        }
        if (this.webSocketHandler != null) {
            this.webSocketHandler.getOnConnectionCallbacks().remove(0);
            this.webSocketHandler.getOnCloseCallbacks().remove(0);
        }
    }

    public void dispose() {
        if (this.resourceHandler != null) {
            this.resourceHandler.dispose();
            this.resourceHandler = null;
        }
        if (this.fluxCapacitor != null) {
            this.fluxCapacitor.unregisterInboundHandler(this.resolvedPath);
        }
        this.disengageFluxCapacitor();
        this.webSocketServer = null;
        this.webSocketHandler = null;
    }

    private ForwardingWebSocketHandler createHandler() {
        this.resolvedPath = this.resolvePath();
        return new ForwardingWebSocketHandler(this.resolvedPath, this.webSocketServer.getServerSettings().getIdleSocketTimeoutInMillis(), r -> WebSocketUtils.getSocketId(this.config, r.getRequestUri().getPath()));
    }

    private Result<InputStream, InboundWebSocketAttributes> toResult(WebSocketMessage message) {
        return Result.builder().output(message.getContent().getValue()).mediaType(message.getContent().getDataType().getMediaType()).attributes((Object)this.toAttributes(message)).build();
    }

    private InboundWebSocketAttributes toAttributes(WebSocketMessage message) {
        return new InboundWebSocketAttributes(message.getSocket(), message.getRequest());
    }
}

