/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.ws.internal.server;

import com.mulesoft.connectors.ws.api.InboundWebSocketAttributes;
import com.mulesoft.connectors.ws.internal.connection.WebSocketState;
import com.mulesoft.connectors.ws.internal.server.OnCloseCallback;
import com.mulesoft.connectors.ws.internal.server.OnConnectCallback;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Function;
import org.mule.runtime.http.api.server.ws.WebSocketConnectionHandler;
import org.mule.runtime.http.api.server.ws.WebSocketConnectionRejectedException;
import org.mule.runtime.http.api.server.ws.WebSocketHandler;
import org.mule.runtime.http.api.server.ws.WebSocketMessage;
import org.mule.runtime.http.api.server.ws.WebSocketMessageHandler;
import org.mule.runtime.http.api.server.ws.WebSocketRequest;
import org.mule.runtime.http.api.ws.WebSocket;
import org.mule.runtime.http.api.ws.WebSocketCloseCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForwardingWebSocketHandler
implements WebSocketHandler {
    private final String path;
    private final Function<WebSocketRequest, String> socketIdGenerator;
    private final List<OnConnectCallback> onConnectionCallbacks = new CopyOnWriteArrayList<OnConnectCallback>();
    private final List<OnCloseCallback> onCloseCallbacks = new CopyOnWriteArrayList<OnCloseCallback>();
    private final WebSocketConnectionHandler connectionHandler = new ForwardingConnectionHandler();
    private final long idleSocketTimeoutMillis;
    private WebSocketMessageHandlerQueue messageHandler;

    public ForwardingWebSocketHandler(String path, long idleSocketTimeoutMillis, Function<WebSocketRequest, String> socketIdGenerator) {
        this.path = path;
        this.idleSocketTimeoutMillis = idleSocketTimeoutMillis;
        this.socketIdGenerator = socketIdGenerator;
    }

    public String getPath() {
        return this.path;
    }

    public WebSocketConnectionHandler getConnectionHandler() {
        return this.connectionHandler;
    }

    public WebSocketMessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public long getIdleSocketTimeoutMills() {
        return this.idleSocketTimeoutMillis;
    }

    public List<OnConnectCallback> getOnConnectionCallbacks() {
        return this.onConnectionCallbacks;
    }

    public List<OnCloseCallback> getOnCloseCallbacks() {
        return this.onCloseCallbacks;
    }

    public void setMessageHandler(WebSocketMessageHandler messageHandler) {
        this.messageHandler = new WebSocketMessageHandlerQueue(messageHandler);
    }

    private static class WebSocketMessageHandlerQueue
    implements WebSocketMessageHandler {
        private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketMessageHandlerQueue.class);
        private final WebSocketMessageHandler messageHandler;
        private final BlockingQueue<WebSocketMessage> queuedMessages;
        private volatile boolean connectionSucceeded = false;
        private volatile boolean connectionRejected = false;

        public WebSocketMessageHandlerQueue(WebSocketMessageHandler handler) {
            this.messageHandler = handler;
            this.queuedMessages = new LinkedBlockingQueue<WebSocketMessage>();
        }

        public synchronized void onMessage(WebSocketMessage message) {
            if (this.connectionRejected) {
                LOGGER.info(String.format("Message %d not processed because connection was rejected!", message.hashCode()));
                return;
            }
            if (this.connectionSucceeded) {
                this.messageHandler.onMessage(message);
            } else {
                this.queuedMessages.add(message);
            }
        }

        public synchronized void notifyConnectionSuccessful() {
            this.connectionSucceeded = true;
            this.connectionRejected = false;
            try {
                while (!this.queuedMessages.isEmpty()) {
                    WebSocketMessage message = (WebSocketMessage)this.queuedMessages.poll();
                    if (message == null) continue;
                    this.messageHandler.onMessage(message);
                }
            }
            catch (Exception e) {
                LOGGER.error(String.format("Waiting on queued messages interrupted: %s", e.getCause()));
                Thread.currentThread().interrupt();
            }
        }

        public synchronized void notifyConnectionRejected() {
            this.connectionSucceeded = false;
            this.connectionRejected = true;
            this.queuedMessages.clear();
            LOGGER.info("Connection rejected notification received! Queued messages have been discarded!");
        }
    }

    private class ForwardingConnectionHandler
    implements WebSocketConnectionHandler {
        private ForwardingConnectionHandler() {
        }

        public String getSocketId(WebSocketRequest request) {
            return (String)ForwardingWebSocketHandler.this.socketIdGenerator.apply(request);
        }

        public void onConnect(WebSocket socket, WebSocketRequest request) throws WebSocketConnectionRejectedException {
            try {
                for (OnConnectCallback callback : ForwardingWebSocketHandler.this.onConnectionCallbacks) {
                    callback.onConnect(socket, request);
                }
                ForwardingWebSocketHandler.this.messageHandler.notifyConnectionSuccessful();
            }
            catch (Exception e) {
                ForwardingWebSocketHandler.this.messageHandler.notifyConnectionRejected();
                throw e;
            }
        }

        public void onClose(WebSocket socket, WebSocketRequest request, WebSocketCloseCode closeCode, String reason) {
            for (OnCloseCallback callback : ForwardingWebSocketHandler.this.onCloseCallbacks) {
                callback.onClose(new WebSocketState(socket, new InboundWebSocketAttributes(socket, request)), closeCode, reason);
            }
        }
    }
}

