/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.ws.internal.util;

import com.mulesoft.connectors.ws.internal.ListenerPath;
import com.mulesoft.connectors.ws.internal.WebSocketsConnector;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import org.mule.runtime.api.streaming.bytes.CursorStream;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.UUID;
import org.mule.runtime.core.api.util.func.CheckedConsumer;

public final class WebSocketUtils {
    public static ListenerPath getFullListenerPath(String path, String basePath) {
        Preconditions.checkArgument((boolean)path.startsWith("/"), (String)"listenerPath must start with /");
        return new ListenerPath(basePath, path);
    }

    public static String sanitizePathWithStartSlash(String path) {
        if (path == null) {
            return null;
        }
        return path.startsWith("/") ? path : "/" + path;
    }

    public static String getSocketId(WebSocketsConnector config, String path) {
        return config.getName() + path + "/" + UUID.getUUID();
    }

    public static String asDSLElement(String componentName) {
        return "<websocket:" + componentName + ">";
    }

    public static <T> CompletableFuture<T> failedFuture(Throwable t) {
        CompletableFuture f = new CompletableFuture();
        f.completeExceptionally(t);
        return f;
    }

    public static void ifRepeatable(InputStream stream, CheckedConsumer<CursorStream> cursor) {
        if (stream.markSupported() && stream instanceof CursorStream) {
            cursor.accept((Object)((CursorStream)stream));
        }
    }

    public static String pathWithoutEndSlash(String path) {
        if (path.endsWith("/")) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static String resolveFullPath(String basePath, String path) {
        if (basePath == null || basePath.isEmpty()) {
            return basePath;
        }
        String sanitizedBasePath = WebSocketUtils.sanitizePathWithStartSlash(basePath);
        sanitizedBasePath = WebSocketUtils.pathWithoutEndSlash(sanitizedBasePath);
        if (path == null || path.isEmpty()) {
            return sanitizedBasePath;
        }
        String resourcePath = WebSocketUtils.sanitizePathWithStartSlash(path);
        return sanitizedBasePath + resourcePath;
    }

    private WebSocketUtils() {
    }
}

