/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.x12.extension.internal.config;

import com.mulesoft.connectors.commons.template.config.ConnectorConfig;
import com.mulesoft.connectors.x12.UsageKludge;
import com.mulesoft.connectors.x12.extension.api.config.X12Variation;
import com.mulesoft.connectors.x12.extension.internal.connection.Provider;
import com.mulesoft.connectors.x12.extension.internal.operation.X12Operations;
import com.mulesoft.connectors.x12.extension.internal.param.DocumentParams;
import com.mulesoft.connectors.x12.extension.internal.param.IdentityParams;
import com.mulesoft.connectors.x12.extension.internal.param.ParserParams;
import com.mulesoft.connectors.x12.extension.internal.param.WriterParams;
import com.mulesoft.connectors.x12.extension.internal.service.function.IncrementStringOp;
import com.mulesoft.connectors.x12pre.extension.internal.schemas.SchemaCache;
import com.mulesoft.connectors.x12pre.extension.internal.schemas.SchemaSet;
import com.mulesoft.flatfile.schema.model.EdiForm;
import com.mulesoft.flatfile.schema.model.EdiFormConverter;
import com.mulesoft.flatfile.schema.model.EdiSchemaVersion;
import com.mulesoft.flatfile.schema.model.Structure;
import com.mulesoft.flatfile.schema.x12.X12AckSchema;
import com.mulesoft.flatfile.schema.x12.X12AckSchema$;
import com.mulesoft.flatfile.schema.x12.X12Form$;
import com.mulesoft.flatfile.schema.x12.X12FormConverter$;
import com.mulesoft.flatfile.schema.yaml.YamlReader;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.store.ObjectAlreadyExistsException;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.api.store.ObjectStoreSettings;
import org.mule.runtime.extension.api.annotation.Configuration;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.connectivity.ConnectionProviders;
import org.mule.runtime.extension.api.annotation.param.DefaultEncoding;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.Some;

@ConnectionProviders(value={Provider.class})
@Operations(value={X12Operations.class})
@Configuration(name="config")
public class X12Config
implements ConnectorConfig,
Initialisable {
    private static final Logger logger = LoggerFactory.getLogger(X12Config.class);
    private static final String ID_OBJECT_STORE = "X12ConnectorIdentifierObjectStore";
    private static final int LOCK_RETRY_COUNT = 10;
    private static final int RELEASE_RETRY_COUNT = 12;
    private static final int STORE_RETRY_COUNT = 5;
    private static final long BASE_RETRY_DELAY_MS = 100L;
    private static final long MAX_RETRY_DELAY_MS = 6000L;
    private static final long LOCK_WAIT_SECONDS = 15L;
    public static final String FAILED_TRYING_TO = "Failed trying to ";
    @ParameterGroup(name="Identity")
    private IdentityParams identityParams;
    @ParameterGroup(name="Document")
    private DocumentParams documentParams;
    @ParameterGroup(name="Parser")
    private ParserParams parserParams;
    @ParameterGroup(name="Writer")
    private WriterParams writerParams;
    @Inject
    private LockFactory lockFactory;
    @Inject
    private ObjectStoreManager objectStoreManager;
    @DefaultEncoding
    private String muleEncoding;
    @Inject
    private SchemaCache schemaCache;
    private SchemaSet schemaSet;
    private X12AckSchema acknowledgmentSchema;
    private ObjectStore counterObjectStore;

    public IdentityParams getIdentityParams() {
        return this.identityParams;
    }

    public void setIdentityParams(IdentityParams identityParams) {
        this.identityParams = identityParams;
    }

    public DocumentParams getDocumentParams() {
        return this.documentParams;
    }

    public void setDocumentParams(DocumentParams documentParams) {
        this.documentParams = documentParams;
    }

    public WriterParams getWriterParams() {
        return this.writerParams;
    }

    public void setWriterParams(WriterParams writerParams) {
        this.writerParams = writerParams;
    }

    public ParserParams getParserParams() {
        return this.parserParams;
    }

    public void setParserParams(ParserParams parserParams) {
        this.parserParams = parserParams;
    }

    public void initialise() throws InitialisationException {
        this.validateParametersAreConfigured();
        try {
            this.documentParams.validate(this.muleEncoding);
            this.writerParams.validate();
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        Integer daysToStore = this.parserParams.getDaysToStore();
        long ttl = daysToStore.longValue() * 24L * 60L * 60L * 1000L;
        this.counterObjectStore = this.objectStoreManager.getOrCreateObjectStore(ID_OBJECT_STORE, ObjectStoreSettings.builder().persistent(true).maxEntries(Integer.valueOf(0)).entryTtl(Long.valueOf(ttl)).expirationInterval(Long.valueOf(ttl / 4L)).build());
        try {
            X12Variation variation = this.documentParams.getFormValidation();
            boolean gen999 = this.parserParams.isGenerate999Acks();
            boolean basex12 = variation.ediForm == X12Form$.MODULE$;
            List<String> schemas = this.documentParams.getSchemas();
            this.schemaSet = schemas == null || schemas.isEmpty() ? new SchemaSet(basex12, gen999, variation.ediForm, this.schemaCache) : new SchemaSet(basex12, gen999, variation.ediForm, this.schemaCache, schemas);
            String path = this.getParserParams().getAcknowledgmentSchemaPath();
            Some optack = null;
            if (path != null) {
                optack = Some.apply((Object)this.schemaCache.getSchema(path, new YamlReader((EdiFormConverter)X12FormConverter$.MODULE$)));
            }
            this.acknowledgmentSchema = new X12AckSchema(X12AckSchema$.MODULE$.acknowledgmentDef((Option)optack, false, EdiSchemaVersion.apply((EdiForm)variation.ediForm)));
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        UsageKludge.kludge();
    }

    public Map<String, Map<String, Structure>> getVersionStructures() {
        return this.schemaSet.getVersionStructures();
    }

    public Structure getStructureSchema(String version, String verpath, String setId) {
        return this.schemaSet.getStructureSchema(version, verpath, setId);
    }

    private void validateParametersAreConfigured() throws InitialisationException {
        if (this.parserParams == null) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"Parser has not been configured"), (Initialisable)this);
        }
        if (this.documentParams == null) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"Document has not been configured"), (Initialisable)this);
        }
        if (this.writerParams == null) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"Writer has not been configured"), (Initialisable)this);
        }
        if (this.identityParams == null) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"Identity has not been configured"), (Initialisable)this);
        }
    }

    private <R> R osWithRetrys(int retryCount, long baseDelay, long maxDelay, String task, ObjectStoreOp<R> body) {
        long delay = baseDelay;
        ObjectStoreException ex = null;
        for (int retrys = retryCount; retrys > 0; --retrys) {
            try {
                return body.apply();
            }
            catch (ObjectStoreException e) {
                ex = e;
                logger.warn("Exception attempting to " + task, (Throwable)e);
                try {
                    Thread.currentThread();
                    Thread.sleep(delay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                delay = Math.min(delay * 2L, maxDelay);
                continue;
            }
        }
        logger.error(FAILED_TRYING_TO + task, (Throwable)ex);
        throw new RuntimeException(FAILED_TRYING_TO + task, ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <R> R executeWithLock(String key, String task, ObjectStoreOp<R> body) {
        Lock lock = this.lockFactory.createLock(key);
        try {
            if (!lock.tryLock(15L, TimeUnit.SECONDS)) throw new RuntimeException("Could not acquire lock to increment number " + key);
            try {
                String lockKey = key + "-LOCK";
                this.osWithRetrys(10, 100L, 6000L, "acquire ObjectStore lock " + lockKey, () -> {
                    this.counterObjectStore.store(lockKey, (Serializable)Boolean.TRUE);
                    return true;
                });
                R result = null;
                RuntimeException re = null;
                try {
                    result = body.apply();
                }
                catch (ObjectStoreException e) {
                    re = new RuntimeException(FAILED_TRYING_TO + task, e);
                    throw re;
                }
                finally {
                    block15: {
                        try {
                            this.osWithRetrys(12, 100L, 6000L, "release ObjectStore lock " + lockKey, () -> {
                                this.counterObjectStore.remove(lockKey);
                                return true;
                            });
                        }
                        catch (RuntimeException e) {
                            if (re == null) break block15;
                            throw re;
                        }
                    }
                }
                R r = result;
                return r;
            }
            finally {
                lock.unlock();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failed acquiring lock to increment number " + key);
        }
    }

    public boolean cacheIdentifier(String ident) {
        return this.osWithRetrys(5, 100L, 6000L, "cache identifier " + ident, () -> {
            try {
                this.counterObjectStore.store(ident, (Serializable)((Object)""));
                return true;
            }
            catch (ObjectAlreadyExistsException e) {
                return false;
            }
        });
    }

    public Integer getNextInteger(String key, int initial) {
        return this.executeWithLock(key, "increment counter " + key, () -> {
            Integer count;
            if (this.counterObjectStore.contains(key)) {
                count = this.getIntegerValue(this.counterObjectStore.retrieve(key));
                if (count == null) {
                    throw new RuntimeException("Integer value expected for key: " + key);
                }
                count = count + 1;
                this.counterObjectStore.remove(key);
            } else {
                count = initial;
            }
            this.counterObjectStore.store(key, (Serializable)count);
            return count;
        });
    }

    private Integer getIntegerValue(Object value) {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof TypedValue) {
            String countVal;
            Object typedValue = ((TypedValue)value).getValue();
            if (typedValue instanceof Integer) {
                return (Integer)typedValue;
            }
            if (typedValue instanceof String && StringUtils.isNumeric((CharSequence)(countVal = (String)typedValue))) {
                return Integer.valueOf(countVal);
            }
        }
        return null;
    }

    public String getNextString(String key, String initial, IncrementStringOp incrementStringOp) {
        return this.executeWithLock(key, "increment counter string " + key, () -> {
            String count;
            if (this.counterObjectStore.contains(key)) {
                count = this.getStringValue(this.counterObjectStore.retrieve(key));
                if (count == null) {
                    throw new RuntimeException("String value expected for key: " + key);
                }
                count = incrementStringOp.increment(count);
                this.counterObjectStore.remove(key);
            } else {
                count = initial;
            }
            this.counterObjectStore.store(key, (Serializable)((Object)count));
            return count;
        });
    }

    private String getStringValue(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof TypedValue) {
            Object typedValue = ((TypedValue)value).getValue();
            if (typedValue instanceof String) {
                return (String)typedValue;
            }
            if (typedValue instanceof Integer) {
                return String.valueOf(typedValue);
            }
        }
        return null;
    }

    public X12AckSchema getAcknowledgmentSchema() {
        return this.acknowledgmentSchema;
    }

    public SchemaSet getSchemaSet() {
        return this.schemaSet;
    }

    private static interface ObjectStoreOp<R> {
        public R apply() throws ObjectStoreException;
    }
}

