/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.x12.extension.internal.operation;

import com.mulesoft.connectors.commons.template.connection.ConnectorConnection;
import com.mulesoft.connectors.x12.extension.api.X12WriteAttributes;
import com.mulesoft.connectors.x12.extension.api.config.OutputEdiMimeType;
import com.mulesoft.connectors.x12.extension.internal.config.X12Config;
import com.mulesoft.connectors.x12.extension.internal.exception.TypeProvider;
import com.mulesoft.connectors.x12.extension.internal.metadata.InputResolver;
import com.mulesoft.connectors.x12.extension.internal.service.ServiceImpl;
import com.mulesoft.connectors.x12.extension.internal.service.builder.X12WriteAttributesBuilder;
import java.io.InputStream;
import java.util.Map;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.ConfigOverride;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.runtime.operation.Result;

@Throws(value={TypeProvider.class})
public class X12Operations {
    @OutputResolver(output=com.mulesoft.connectors.x12.extension.internal.metadata.OutputResolver.class)
    public Map<String, Object> read(@Config X12Config config, @Content InputStream readContent, @Connection ConnectorConnection connection) {
        ServiceImpl service = new ServiceImpl(config, connection);
        return service.read(readContent);
    }

    @MediaType(value="application/plain")
    public Result<InputStream, X12WriteAttributes> write(@Config X12Config config, @Content @TypeResolver(value=InputResolver.class) Map<String, Object> writeContent, @Connection ConnectorConnection connection, @ConfigOverride @DisplayName(value="Output EDI MIME Type") OutputEdiMimeType outputEdiMimeType, @ConfigOverride String interchangeNumberKey, @ConfigOverride String groupNumberKey, @ConfigOverride String transactionNumberKey) {
        this.overrideControlNumberKeys(config, interchangeNumberKey, groupNumberKey, transactionNumberKey);
        Result.Builder resultBuilder = Result.builder().output((Object)new ServiceImpl(config, connection).write(writeContent)).attributes((Object)new X12WriteAttributesBuilder().build(writeContent));
        OutputEdiMimeType outputEdiMime = config.getWriterParams().getOutputEdiMimeType();
        if (outputEdiMime != null) {
            if (outputEdiMimeType.getOutputEdiMimeType().equalsIgnoreCase("application/edi-x12")) {
                return resultBuilder.mediaType(org.mule.runtime.api.metadata.MediaType.create((String)"application", (String)"edi-x12")).build();
            }
            if (outputEdiMimeType == null && outputEdiMime.getOutputEdiMimeType().equalsIgnoreCase("application/edi-x12")) {
                return resultBuilder.mediaType(org.mule.runtime.api.metadata.MediaType.create((String)"application", (String)"edi-x12")).build();
            }
        }
        return resultBuilder.build();
    }

    private void overrideControlNumberKeys(X12Config config, String interchangeNumberKey, String groupNumberKey, String transactionNumberKey) {
        if (!this.isEmpty(interchangeNumberKey)) {
            config.getWriterParams().setInterchangeNumberKey(interchangeNumberKey);
        }
        if (!this.isEmpty(groupNumberKey)) {
            config.getWriterParams().setGroupNumberKey(groupNumberKey);
        }
        if (!this.isEmpty(transactionNumberKey)) {
            config.getWriterParams().setTransactionNumberKey(transactionNumberKey);
        }
    }

    private boolean isEmpty(String s) {
        return s == null || s.isEmpty();
    }
}

