/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.x12.extension.internal.param;

import com.mulesoft.connectors.x12.extension.api.config.OutputEdiMimeType;
import com.mulesoft.connectors.x12.extension.api.config.SegmentWhitespace;
import java.util.HashSet;
import java.util.stream.Stream;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class WriterParams {
    @Parameter
    @Optional(defaultValue="*")
    @Placement(tab="Writer", order=1)
    @DisplayName(value="Data element separator")
    @Summary(value="Data element separator character")
    private String dataSeparator;
    @Parameter
    @Optional(defaultValue=">")
    @Placement(tab="Writer", order=2)
    @DisplayName(value="Component element separator")
    @Summary(value="Component element separator character")
    private String componentSeparator;
    @Parameter
    @Optional(defaultValue="U")
    @Placement(tab="Writer", order=3)
    @DisplayName(value="Repetition separator")
    @Summary(value="Repetition separator character (if used)")
    private String repetitionSeparator;
    @Parameter
    @Optional(defaultValue="~")
    @Placement(tab="Writer", order=4)
    @DisplayName(value="Segment terminator")
    @Summary(value="Segment terminator character")
    private String segmentTerminator;
    @Parameter
    @Optional(defaultValue="NONE")
    @Placement(tab="Writer", order=6)
    @DisplayName(value="Segment line ending")
    @Summary(value="Line ending to add between segments")
    private SegmentWhitespace lineEnding;
    @Parameter
    @Optional
    @Placement(tab="Writer", order=7)
    @DisplayName(value="Unique group numbers")
    @Summary(value="Send globally unique Group Control Numbers (GS06)")
    private boolean sendUniqueGroupNumbers;
    @Parameter
    @Optional
    @Placement(tab="Writer", order=8)
    @DisplayName(value="Unique transaction numbers")
    @Summary(value="Send globally unique Transaction Set Control Numbers (ST02)")
    private boolean sendUniqueTransactionNumbers;
    @Parameter
    @Optional
    @Placement(tab="Writer", order=9)
    @DisplayName(value="Implementation reference")
    @Summary(value="Implementation convention reference for transactions (ST03)")
    private String implementationConventionReference;
    @Parameter
    @Optional(defaultValue="1")
    @Placement(tab="Writer", order=10)
    @DisplayName(value="Initial interchange number")
    @Summary(value="The initial Interchange Control Number used for outgoing messages")
    private int initialInterchangeNumber;
    @Parameter
    @Optional(defaultValue="1")
    @Placement(tab="Writer", order=11)
    @DisplayName(value="Initial group number")
    @Summary(value="The initial Group Control Number used for outgoing messages")
    private int initialGroupNumber;
    @Parameter
    @Optional(defaultValue="1")
    @Placement(tab="Writer", order=12)
    @DisplayName(value="Initial transaction number")
    @Summary(value="The initial Transaction Set Control Number used for outgoing messages")
    private String initialSetNumber;
    @Parameter
    @Optional
    @Placement(tab="Writer", order=13)
    @DisplayName(value="Request acknowledgments")
    @Summary(value="Request acknowledgments for sent transactions flag (ISA14)")
    private boolean ackRequested;
    @Parameter
    @Optional(defaultValue="P")
    @Placement(tab="Writer", order=14)
    @DisplayName(value="Default usage indicator")
    @Summary(value="Default interchange usage indicator (ISA15): 'I' for Information, 'P' for Production Data, 'T' for Test Data")
    private String defaultUsageIndicator;
    @Parameter
    @Optional
    @Placement(tab="Writer", order=15)
    @DisplayName(value="Use supplied values")
    @Summary(value="Use supplied values (if present) for all fields, including control numbers")
    private boolean useSuppliedValues;
    @Parameter
    @Optional(defaultValue="APPLICATION_PLAIN")
    @Placement(tab="Writer", order=16)
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Output mime type")
    @Summary(value="Output mime type")
    private OutputEdiMimeType outputEdiMimeType;
    @Parameter
    @Optional(defaultValue="true")
    @Placement(tab="Writer", order=17)
    @DisplayName(value="Enforce length limits")
    @Summary(value="Enforce minimum and maximum lengths for write values")
    private boolean writeEnforceLengthLimits;
    @Parameter
    @Optional(defaultValue="false")
    @Placement(tab="Writer", order=18)
    @DisplayName(value="Enforce conditional rules")
    @Summary(value="Enforce Conditional elements to meet its rules")
    private boolean enforceConditionalRulesOnWriter;
    @Parameter
    @Optional
    @Placement(tab="Writer", order=19)
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Interchange number key")
    @Summary(value="Interchange number key name for object store")
    private String interchangeNumberKey;
    @Parameter
    @Optional
    @Placement(tab="Writer", order=20)
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Group number key")
    @Summary(value="Group number key name for object store")
    private String groupNumberKey;
    @Parameter
    @Optional
    @Placement(tab="Writer", order=21)
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Transaction number key")
    @Summary(value="Transaction number key name for object store")
    private String transactionNumberKey;

    public OutputEdiMimeType getOutputEdiMimeType() {
        return this.outputEdiMimeType;
    }

    public void setOutputEdiMimeType(OutputEdiMimeType outputEdiMimeType) {
        this.outputEdiMimeType = outputEdiMimeType;
    }

    public String getDataSeparator() {
        return this.dataSeparator;
    }

    public void setDataSeparator(String dataSeparator) {
        this.dataSeparator = dataSeparator;
    }

    public String getComponentSeparator() {
        return this.componentSeparator;
    }

    public void setComponentSeparator(String componentSeparator) {
        this.componentSeparator = componentSeparator;
    }

    public String getRepetitionSeparator() {
        return this.repetitionSeparator;
    }

    public void setRepetitionSeparator(String repetitionSeparator) {
        this.repetitionSeparator = repetitionSeparator;
    }

    public String getSegmentTerminator() {
        return this.segmentTerminator;
    }

    public void setSegmentTerminator(String segmentTerminator) {
        this.segmentTerminator = segmentTerminator;
    }

    public SegmentWhitespace getLineEnding() {
        return this.lineEnding;
    }

    public void setLineEnding(SegmentWhitespace lineEnding) {
        this.lineEnding = lineEnding;
    }

    public boolean isSendUniqueGroupNumbers() {
        return this.sendUniqueGroupNumbers;
    }

    public void setSendUniqueGroupNumbers(boolean sendUniqueGroupNumbers) {
        this.sendUniqueGroupNumbers = sendUniqueGroupNumbers;
    }

    public boolean isSendUniqueTransactionNumbers() {
        return this.sendUniqueTransactionNumbers;
    }

    public void setSendUniqueTransactionNumbers(boolean sendUniqueTransactionNumbers) {
        this.sendUniqueTransactionNumbers = sendUniqueTransactionNumbers;
    }

    public String getImplementationConventionReference() {
        return this.implementationConventionReference;
    }

    public void setImplementationConventionReference(String implementationConventionReference) {
        this.implementationConventionReference = implementationConventionReference;
    }

    public int getInitialInterchangeNumber() {
        return this.initialInterchangeNumber;
    }

    public void setInitialInterchangeNumber(int initialInterchangeNumber) {
        this.initialInterchangeNumber = initialInterchangeNumber;
    }

    public int getInitialGroupNumber() {
        return this.initialGroupNumber;
    }

    public void setInitialGroupNumber(int initialGroupNumber) {
        this.initialGroupNumber = initialGroupNumber;
    }

    public String getInitialSetNumber() {
        return this.initialSetNumber;
    }

    public void setInitialSetNumber(String initialSetNumber) {
        this.initialSetNumber = initialSetNumber;
    }

    public boolean isAckRequested() {
        return this.ackRequested;
    }

    public void setAckRequested(boolean ackRequested) {
        this.ackRequested = ackRequested;
    }

    public String getDefaultUsageIndicator() {
        return this.defaultUsageIndicator;
    }

    public void setDefaultUsageIndicator(String value) {
        this.defaultUsageIndicator = value;
    }

    public boolean isUseSuppliedValues() {
        return this.useSuppliedValues;
    }

    public void setUseSuppliedValues(boolean useSuppliedValues) {
        this.useSuppliedValues = useSuppliedValues;
    }

    public boolean isWriteEnforceLengthLimits() {
        return this.writeEnforceLengthLimits;
    }

    public void setWriteEnforceLengthLimits(boolean enforceLengthLimits) {
        this.writeEnforceLengthLimits = enforceLengthLimits;
    }

    public String getInterchangeNumberKey() {
        return this.interchangeNumberKey;
    }

    public void setInterchangeNumberKey(String interchangeNumberKey) {
        this.interchangeNumberKey = interchangeNumberKey;
    }

    public String getGroupNumberKey() {
        return this.groupNumberKey;
    }

    public void setGroupNumberKey(String groupNumberKey) {
        this.groupNumberKey = groupNumberKey;
    }

    public String getTransactionNumberKey() {
        return this.transactionNumberKey;
    }

    public void setTransactionNumberKey(String transactionNumberKey) {
        this.transactionNumberKey = transactionNumberKey;
    }

    public boolean isEnforceConditionalRulesOnWriter() {
        return this.enforceConditionalRulesOnWriter;
    }

    public void setEnforceConditionalRulesOnWriter(boolean enforceConditionalRulesOnWriter) {
        this.enforceConditionalRulesOnWriter = enforceConditionalRulesOnWriter;
    }

    private void validateDelimiter(String name, String value) {
        if (value == null || value.length() != 1) {
            throw new RuntimeException(name + " value must be a single character");
        }
        char delim = value.charAt(0);
        if (Character.isAlphabetic(delim) || Character.isDigit(delim)) {
            throw new RuntimeException(name + " must not be an alpha or digit");
        }
    }

    public void validate() {
        this.validateDelimiter("dataSeparator", this.dataSeparator);
        this.validateDelimiter("componentSeparator", this.componentSeparator);
        this.validateDelimiter("segmentTerminator", this.segmentTerminator);
        if (!"U".equals(this.repetitionSeparator)) {
            this.validateDelimiter("repetitionSeparator", this.repetitionSeparator);
        }
        if (this.defaultUsageIndicator == null || this.defaultUsageIndicator.length() != 1) {
            throw new RuntimeException(this.defaultUsageIndicator + " value must be a single character");
        }
        this.validateControlNumberKeys();
    }

    private void validateControlNumberKeys() {
        HashSet uniqueValues = new HashSet();
        long duplicates = Stream.of(this.interchangeNumberKey, this.groupNumberKey, this.transactionNumberKey).filter(k -> k != null && !k.isEmpty() && !uniqueValues.add(k)).count();
        if (duplicates > 0L) {
            throw new RuntimeException("Control number keys must be unique");
        }
    }
}

