/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.x12.extension.internal.service;

import com.mulesoft.connectors.x12.extension.api.config.X12Variation;
import com.mulesoft.connectors.x12.extension.internal.config.X12Config;
import com.mulesoft.connectors.x12.extension.internal.param.DocumentParams;
import com.mulesoft.connectors.x12.extension.internal.param.IdentityParams;
import com.mulesoft.connectors.x12.extension.internal.param.ParserParams;
import com.mulesoft.flatfile.schema.model.Structure;
import com.mulesoft.flatfile.schema.x12.HIPAAForm$;
import com.mulesoft.flatfile.schema.x12.X12Acknowledgment;
import com.mulesoft.flatfile.schema.x12.X12EnvelopeHandler;
import com.mulesoft.flatfile.schema.x12.X12HandlerGroupError;
import com.mulesoft.flatfile.schema.x12.X12HandlerInterchangeError;
import com.mulesoft.flatfile.schema.x12.X12HandlerTransactionError;
import com.mulesoft.flatfile.schema.x12.X12ParserConfig;
import com.mulesoft.flatfile.schema.x12.X12SchemaDefs;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DirectEnvelopeHandler
implements X12EnvelopeHandler {
    private static final Logger logger = LoggerFactory.getLogger(DirectEnvelopeHandler.class);
    private X12Config config;
    private Set<String> groupCache;
    private Set<String> setCache;
    private String contextToken;
    private String senderCode;
    private String receiverCode;
    private String versionCode;
    private String functionalCode;
    private boolean requireUniqueTransactionNumbers;

    public DirectEnvelopeHandler(X12Config config) throws Exception {
        this.config = config;
        this.requireUniqueTransactionNumbers = config.getParserParams().isRequireUniqueTransactionSets();
    }

    public static String requiredString(Object key, Map<String, Object> map) {
        Object value = map.get(key);
        if (value instanceof String) {
            return value.toString();
        }
        throw new IllegalArgumentException("Key " + key + " not present in map or value is not a string");
    }

    public static String optionalString(Object key, Map<String, Object> map) {
        Object value = map.get(key);
        if (value instanceof String) {
            return value.toString();
        }
        return "";
    }

    public static int requiredInt(Object key, Map<String, Object> map) {
        Object value = map.get(key);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        throw new IllegalArgumentException("Key " + key + " not present in map or value is not an integer");
    }

    public static boolean verifySetting(String value, Object key, Map<String, Object> map) {
        if (value != null) {
            return value.equals(map.get(key));
        }
        return true;
    }

    protected String createIdentifier(String contextToken, String senderCode, String receiverCode, Object controlNum, String delimiter) {
        return contextToken + senderCode + receiverCode + delimiter + controlNum;
    }

    protected X12HandlerInterchangeError checkIds(String sendQual, String sendId, String rcvrQual, String rcvrId, Map<String, Object> map) {
        if (!DirectEnvelopeHandler.verifySetting(sendQual, X12SchemaDefs.interSenderQualKey(), map)) {
            return new X12HandlerInterchangeError(X12Acknowledgment.InterchangeSenderIdQual(), "Interchange sender qualifier does not match configuration");
        }
        if (!DirectEnvelopeHandler.verifySetting(sendId, X12SchemaDefs.interSenderInfoKey(), map)) {
            return new X12HandlerInterchangeError(X12Acknowledgment.InterchangeSenderId(), "Interchange sender id does not match configuration");
        }
        if (!DirectEnvelopeHandler.verifySetting(rcvrQual, X12SchemaDefs.interReceiverQualKey(), map)) {
            return new X12HandlerInterchangeError(X12Acknowledgment.InterchangeReceiverIdQual(), "Interchange receiver qualifier does not match configuration");
        }
        if (!DirectEnvelopeHandler.verifySetting(rcvrId, X12SchemaDefs.interReceiverInfoKey(), map)) {
            return new X12HandlerInterchangeError(X12Acknowledgment.InterchangeReceiverId(), "Interchange receiver id does not match configuration");
        }
        return null;
    }

    public Object handleIsa(Map<String, Object> map) {
        this.contextToken = DirectEnvelopeHandler.requiredString(X12SchemaDefs.interSenderQualKey(), map) + DirectEnvelopeHandler.requiredString(X12SchemaDefs.interSenderInfoKey(), map) + DirectEnvelopeHandler.requiredString(X12SchemaDefs.interReceiverQualKey(), map) + DirectEnvelopeHandler.requiredString(X12SchemaDefs.interReceiverInfoKey(), map);
        IdentityParams identity = this.config.getIdentityParams();
        X12HandlerInterchangeError error = this.checkIds(identity.getInterchangeIdQualifierPartner(), identity.getInterchangeIdPartner(), identity.getInterchangeIdQualifierSelf(), identity.getInterchangeIdSelf(), map);
        if (error != null) {
            return error;
        }
        ParserParams parser = this.config.getParserParams();
        int controlNum = DirectEnvelopeHandler.requiredInt(X12SchemaDefs.interControlNumberHeaderKey(), map);
        if (parser.isRequireUniqueInterchanges() && !this.config.cacheIdentifier(this.contextToken + controlNum)) {
            return this.createDuplicateX12HandlerInterchangeError(controlNum);
        }
        if (!this.config.getParserParams().isRequireUniqueGroups()) {
            this.groupCache = new HashSet<String>();
        }
        DocumentParams document = this.config.getDocumentParams();
        String subst = document.getStringSubstitutionChar();
        return new X12ParserConfig(parser.isEnforceLengthLimits(), parser.isEnforceCharacterSet(), parser.isEnforceValueRepeats(), !parser.isAllowUnknownSegments(), parser.isEnforceSegmentOrder(), !parser.isAllowUnusedSegments(), parser.isEnforceSegmentRepeats(), this.isFatalSyntaxFail(parser, document), document.getFormValidation() == X12Variation.HIPAA_SNIP2, parser.isReportSegmentErrors(), parser.isAckAllSets(), parser.isGenerate999Acks(), subst != null ? (int)subst.charAt(0) : -1, document.getStringCharacterSet().characterRestriction, parser.isGenerate999Acks() ? this.config.getSchemaSet().getAckSchema() : this.config.getAcknowledgmentSchema());
    }

    private boolean isFatalSyntaxFail(ParserParams parser, DocumentParams document) {
        return document.getFormValidation().ediForm == HIPAAForm$.MODULE$ || parser.isEnforceConditionalRulesOnParser();
    }

    public Object handleGs(Map<String, Object> map) {
        return this.doHandleGs(this.config.getParserParams().isRequireUniqueGroups(), map);
    }

    private Object doHandleGs(boolean requireUniqueGroupNumbers, Map<String, Object> map) {
        IdentityParams identity = this.config.getIdentityParams();
        if (!DirectEnvelopeHandler.verifySetting(identity.getGroupIdPartner(), X12SchemaDefs.groupApplicationSenderKey(), map) || !DirectEnvelopeHandler.verifySetting(identity.getGroupIdSelf(), X12SchemaDefs.groupApplicationReceiverKey(), map)) {
            return new X12HandlerGroupError(X12Acknowledgment.NotSupportedGroup(), "Group application sender/receiver information does not match configuration");
        }
        int controlNum = DirectEnvelopeHandler.requiredInt(X12SchemaDefs.groupControlNumberHeaderKey(), map);
        this.senderCode = DirectEnvelopeHandler.requiredString(X12SchemaDefs.groupApplicationSenderKey(), map);
        this.receiverCode = DirectEnvelopeHandler.requiredString(X12SchemaDefs.groupApplicationReceiverKey(), map);
        if (requireUniqueGroupNumbers ? !this.isUniqueGroupNumber(this.contextToken, this.senderCode, this.receiverCode, controlNum, map) : !this.groupCache.add(this.createIdentifier(this.contextToken, this.senderCode, this.receiverCode, controlNum, ":"))) {
            return new X12HandlerGroupError(X12Acknowledgment.GroupControlNumberError(), "Duplicate group control number " + controlNum);
        }
        String agency = DirectEnvelopeHandler.requiredString(X12SchemaDefs.groupResponsibleAgencyKey(), map);
        if (!"X".equals(agency)) {
            return new X12HandlerGroupError(X12Acknowledgment.NotSupportedGroupVersion(), "Group responsible agency code must be 'X' (found " + agency + ")");
        }
        String code = DirectEnvelopeHandler.requiredString(X12SchemaDefs.groupVersionReleaseIndustryKey(), map);
        if (code.length() < 6) {
            return new X12HandlerGroupError(X12Acknowledgment.NotSupportedGroupVersion(), "Group version / release / industry identifier code less than 6 characters: '" + code + "'");
        }
        this.versionCode = code;
        this.functionalCode = DirectEnvelopeHandler.requiredString(X12SchemaDefs.groupFunctionalIdentifierKey(), map);
        if (!this.requireUniqueTransactionNumbers) {
            this.setCache = new HashSet<String>();
        }
        return null;
    }

    protected X12HandlerInterchangeError createDuplicateX12HandlerInterchangeError(int controlNum) {
        return new X12HandlerInterchangeError(X12Acknowledgment.InterchangeDuplicateNumber(), "Duplicate interchange control number " + controlNum);
    }

    protected boolean isUniqueGroupNumber(String contextToken, String senderCode, String receiverCode, int controlNum, Map<String, Object> map) {
        return this.config.cacheIdentifier(this.createIdentifier(contextToken, senderCode, receiverCode, controlNum, ":"));
    }

    public Object handleSt(Map<String, Object> map) {
        Structure structure;
        String controlNum = DirectEnvelopeHandler.requiredString(X12SchemaDefs.setControlNumberHeaderKey(), map);
        if (this.requireUniqueTransactionNumbers ? !this.isUniqueTransactionNumber(this.contextToken, this.senderCode, this.receiverCode, controlNum) : !this.setCache.add(this.createIdentifier(this.contextToken, this.senderCode, this.receiverCode, controlNum, "$"))) {
            return new X12HandlerTransactionError(X12Acknowledgment.BadTransactionSetControl(), "Duplicate transaction set control number " + controlNum);
        }
        String setId = DirectEnvelopeHandler.requiredString(X12SchemaDefs.setIdentifierCodeKey(), map);
        try {
            String suffix = this.config.getDocumentParams().getVersionIdentifierSuffix();
            if (suffix == null) {
                suffix = "";
            }
            String version = this.versionCode.substring(0, this.versionCode.length() - suffix.length());
            if (map.containsKey(X12SchemaDefs.setImplementationConventionKey())) {
                version = DirectEnvelopeHandler.requiredString(X12SchemaDefs.setImplementationConventionKey(), map);
            }
            if ((structure = this.config.getStructureSchema("v" + version, version, setId)) == null) {
                return new X12HandlerTransactionError(X12Acknowledgment.NotSupportedTransaction(), "Transaction not defined in schema");
            }
            if (!(structure.version().version() + suffix).equals(this.versionCode)) {
                String append = suffix.length() > 0 ? " and suffix " + suffix : "";
                logger.warn("Configured schema version " + structure.version().version() + " does not match transaction set version " + this.versionCode + append);
            }
        }
        catch (Exception e) {
            return new X12HandlerTransactionError(X12Acknowledgment.NotSupportedTransaction(), "Error accessing transaction schema");
        }
        if (!this.functionalCode.equals(structure.group().get())) {
            return new X12HandlerTransactionError(X12Acknowledgment.SetNotInGroup(), "Functional code " + this.functionalCode + " doesn't match schema");
        }
        return structure;
    }

    protected boolean isUniqueTransactionNumber(String contextToken, String senderCode, String receiverCode, String controlNum) {
        return this.config.cacheIdentifier(this.createIdentifier(contextToken, senderCode, receiverCode, controlNum, "$"));
    }
}

