/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.x12.extension.internal.service;

import com.mulesoft.connectors.commons.template.config.ConnectorConfig;
import com.mulesoft.connectors.commons.template.connection.ConnectorConnection;
import com.mulesoft.connectors.commons.template.service.DefaultConnectorService;
import com.mulesoft.connectors.x12.extension.api.config.X12Variation;
import com.mulesoft.connectors.x12.extension.internal.config.X12Config;
import com.mulesoft.connectors.x12.extension.internal.exception.ParseException;
import com.mulesoft.connectors.x12.extension.internal.exception.WriteException;
import com.mulesoft.connectors.x12.extension.internal.param.DocumentParams;
import com.mulesoft.connectors.x12.extension.internal.param.IdentityParams;
import com.mulesoft.connectors.x12.extension.internal.param.WriterParams;
import com.mulesoft.connectors.x12.extension.internal.service.DirectEnvelopeHandler;
import com.mulesoft.connectors.x12.extension.internal.service.Service;
import com.mulesoft.connectors.x12.extension.internal.utility.CachedOutputStream;
import com.mulesoft.flatfile.schema.SchemaJavaValues;
import com.mulesoft.flatfile.schema.model.Structure;
import com.mulesoft.flatfile.schema.x12.X12EnvelopeHandler;
import com.mulesoft.flatfile.schema.x12.X12Error;
import com.mulesoft.flatfile.schema.x12.X12InterchangeParser;
import com.mulesoft.flatfile.schema.x12.X12NumberProvider;
import com.mulesoft.flatfile.schema.x12.X12SchemaDefs;
import com.mulesoft.flatfile.schema.x12.X12SchemaWriter;
import com.mulesoft.flatfile.schema.x12.X12WriteException;
import com.mulesoft.flatfile.schema.x12.X12WriterConfig;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import scala.util.Try;

public class ServiceImpl
extends DefaultConnectorService<X12Config, ConnectorConnection>
implements Service {
    static final String DATA_NOT_SET_ERR = "Missing required '" + X12SchemaDefs.transactionsMap() + "' value in message payload.";
    static final String MISSING_SCHEMA_ERR = "No schema defined for transaction set: ";
    static final String INVALID_DELIMITER_ERR = "Invalid delimiter character: '";
    static final String DUPLICATE_DELIMITER_ERR = "Duplicate delimiter character: '";
    static final String DELIMITERS_NO_ERR = SchemaJavaValues.delimiterCharacters() + " value must be 4 characters. Found: '";
    static final Integer TRANS_SET_CONTROL_NUM_MAX_LEN = 9;

    public ServiceImpl(X12Config config, ConnectorConnection connection) {
        super((ConnectorConfig)config, connection);
    }

    @Override
    public Map<String, Object> read(InputStream readContent) {
        Try parsed;
        try {
            X12Config x12Config = (X12Config)this.getConfig();
            DocumentParams docparams = x12Config.getDocumentParams();
            X12InterchangeParser parser = new X12InterchangeParser(readContent, this.isCheckSyntax(docparams.getFormValidation(), x12Config.getParserParams().isEnforceConditionalRulesOnParser()), docparams.getCharset(), docparams.getFormValidation().ediForm, (X12EnvelopeHandler)new DirectEnvelopeHandler(x12Config));
            parsed = parser.parse();
        }
        catch (Exception exception) {
            throw new ParseException(exception.getMessage(), (Throwable)exception);
        }
        return (Map)parsed.get();
    }

    private boolean isCheckSyntax(X12Variation formValidation, boolean enforceConditionalRules) {
        return formValidation == X12Variation.HIPAA_SNIP2 || enforceConditionalRules;
    }

    private String getDelimiters(Map<String, Object> message) {
        String delimiters = (String)message.get(SchemaJavaValues.delimiterCharacters());
        WriterParams writeparams = ((X12Config)this.getConfig()).getWriterParams();
        if (delimiters == null) {
            delimiters = writeparams.getDataSeparator() + writeparams.getComponentSeparator() + writeparams.getRepetitionSeparator() + writeparams.getSegmentTerminator();
        } else if (delimiters.length() != 4) {
            throw new WriteException(DELIMITERS_NO_ERR + delimiters + "'");
        }
        this.validateDelimiters(delimiters);
        return delimiters;
    }

    private void validateDelimiters(String delimiters) {
        HashSet<Character> chars = new HashSet<Character>();
        for (int i = 0; i < delimiters.length(); ++i) {
            char delim = delimiters.charAt(i);
            if (delim == 'U') continue;
            if ((Character.isAlphabetic(delim) || Character.isDigit(delim)) && (i != 2 || delim != '\u0000')) {
                throw new WriteException(INVALID_DELIMITER_ERR + delim + "'");
            }
            if (chars.add(Character.valueOf(delim))) continue;
            throw new WriteException(DUPLICATE_DELIMITER_ERR + delim + "'");
        }
    }

    private boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    private void setNullDefault(String key, String dflt, Map<String, Object> map) {
        if (map.get(key) == null && !this.isEmpty(dflt)) {
            map.put(key, dflt);
        }
    }

    public static Object getOrDefault(Map<String, Object> map, String key, Object dflt) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        return dflt;
    }

    public String incrementString(String value, int maxlen) {
        long seq;
        String suffix;
        int split = this.getSplitLengthBeforeTrailingDigits(value);
        int excess = split + (suffix = Long.toString((seq = this.getSequenceValue(value, split)) + 1L)).length() - maxlen;
        if (excess > 0) {
            if (excess >= suffix.length()) {
                throw new RuntimeException("Unable to increment string already at maximum length");
            }
            suffix = suffix.substring(excess);
        }
        return value.substring(0, split) + suffix;
    }

    public String selectString(String storeValue, String initialValue) {
        long storeValueDigits = this.getSequenceValue(storeValue, this.getSplitLengthBeforeTrailingDigits(storeValue));
        long initialValueDigits = this.getSequenceValue(initialValue, this.getSplitLengthBeforeTrailingDigits(initialValue));
        return initialValueDigits > storeValueDigits ? initialValue : storeValue;
    }

    private int getSplitLengthBeforeTrailingDigits(String value) {
        char ch;
        int split;
        for (split = value.length(); split > 0 && (ch = value.charAt(split - 1)) >= '0' && ch <= '9'; --split) {
        }
        return split;
    }

    private long getSequenceValue(String value, int split) {
        return split < value.length() ? Long.parseLong(value.substring(split)) : 0L;
    }

    public String incrementTxSetControlNum(String value) {
        return this.incrementString(value, TRANS_SET_CONTROL_NUM_MAX_LEN);
    }

    @Override
    public InputStream write(Map<String, Object> writeContent) {
        Map transSets = (Map)writeContent.computeIfAbsent(X12SchemaDefs.transactionsMap(), k -> new HashMap());
        String delims = this.getDelimiters(writeContent);
        Map gmap = (Map)writeContent.computeIfAbsent(SchemaJavaValues.groupKey(), k -> new HashMap());
        Map imap = (Map)writeContent.computeIfAbsent(SchemaJavaValues.interchangeKey(), k -> new HashMap());
        final X12Config x12Config = (X12Config)this.getConfig();
        IdentityParams idparams = x12Config.getIdentityParams();
        this.setNullDefault(X12SchemaDefs.interSenderQualKey(), idparams.getInterchangeIdQualifierSelf(), imap);
        this.setNullDefault(X12SchemaDefs.interSenderInfoKey(), idparams.getInterchangeIdSelf(), imap);
        this.setNullDefault(X12SchemaDefs.interReceiverQualKey(), idparams.getInterchangeIdQualifierPartner(), imap);
        this.setNullDefault(X12SchemaDefs.interReceiverInfoKey(), idparams.getInterchangeIdPartner(), imap);
        this.setNullDefault(X12SchemaDefs.groupApplicationSenderKey(), idparams.getGroupIdSelf(), gmap);
        this.setNullDefault(X12SchemaDefs.groupApplicationReceiverKey(), idparams.getGroupIdPartner(), gmap);
        this.setNullDefault(X12SchemaDefs.groupResponsibleAgencyKey(), "X", gmap);
        final WriterParams wrparams = x12Config.getWriterParams();
        if (!this.isEmpty(wrparams.getImplementationConventionReference())) {
            Map smap = (Map)writeContent.computeIfAbsent(X12SchemaDefs.setHeaderKey(), k -> new HashMap());
            smap.put(X12SchemaDefs.setImplementationConventionKey(), wrparams.getImplementationConventionReference());
        }
        String dfltusage = wrparams.isAckRequested() ? "1" : "0";
        this.setNullDefault(X12SchemaDefs.interAckRequestedKey(), dfltusage, imap);
        this.setNullDefault(X12SchemaDefs.interUsageIndicatorKey(), wrparams.getDefaultUsageIndicator(), imap);
        DocumentParams docparams = x12Config.getDocumentParams();
        CachedOutputStream os = new CachedOutputStream();
        String subst = docparams.getStringSubstitutionChar();
        int subChar = subst == null || subst.length() == 0 ? -1 : (int)subst.charAt(0);
        X12WriterConfig config = new X12WriterConfig(true, true, docparams.getStringCharacterSet().characterRestriction, subChar, docparams.getCharset(), delims, wrparams.getLineEnding().whitespace, wrparams.isUseSuppliedValues(), wrparams.isWriteEnforceLengthLimits());
        this.checkSchemaVersions(docparams, writeContent);
        X12Variation formValidation = docparams.getFormValidation();
        X12SchemaWriter writer = new X12SchemaWriter((OutputStream)os, new X12NumberProvider(){
            int groupNum;
            String setNum;

            public String interchangeIdentifier(String senderQual, String senderId, String receiverQual, String receiverId) {
                return senderQual + senderId + receiverQual + receiverId;
            }

            public int nextInterchange(String interchange) {
                this.groupNum = wrparams.getInitialGroupNumber();
                String key = ServiceImpl.this.isEmpty(wrparams.getInterchangeNumberKey()) ? interchange : wrparams.getInterchangeNumberKey();
                return x12Config.getNextInteger(key, wrparams.getInitialInterchangeNumber());
            }

            public int nextGroup(String interchange, String senderCode, String receiverCode) {
                int functionalGroupControlNo;
                this.setNum = wrparams.getInitialSetNumber();
                if (wrparams.isSendUniqueGroupNumbers()) {
                    String key = ServiceImpl.this.isEmpty(wrparams.getGroupNumberKey()) ? interchange + "*" + senderCode + receiverCode : wrparams.getGroupNumberKey();
                    functionalGroupControlNo = x12Config.getNextInteger(key, wrparams.getInitialGroupNumber());
                } else {
                    functionalGroupControlNo = this.groupNum++;
                }
                return functionalGroupControlNo;
            }

            public String nextSet(String interchange, String senderCode, String receiverCode) {
                if (wrparams.isSendUniqueTransactionNumbers()) {
                    String key = ServiceImpl.this.isEmpty(wrparams.getTransactionNumberKey()) ? interchange + "+" + senderCode + receiverCode : wrparams.getTransactionNumberKey();
                    return x12Config.getNextString(key, wrparams.getInitialSetNumber(), ServiceImpl.this::incrementTxSetControlNum);
                }
                String nextSetNum = this.setNum;
                this.setNum = ServiceImpl.this.incrementTxSetControlNum(this.setNum);
                return nextSetNum;
            }
        }, config, formValidation.ediForm, this.isCheckSyntax(formValidation, wrparams.isEnforceConditionalRulesOnWriter()));
        try {
            writer.write(writeContent).get();
            this.clearStructureSchemas(writeContent);
            return os.toInputStream();
        }
        catch (Exception e) {
            os.discard();
            if (e instanceof X12WriteException) {
                X12WriteException xe = (X12WriteException)e;
                X12Error[] errors = xe.errors();
                StringBuilder builder = new StringBuilder("Errors in write operation:");
                for (X12Error error : errors) {
                    builder.append("\n");
                    builder.append(error.getErrorText());
                }
                throw new WriteException(builder.toString());
            }
            throw new WriteException("Irrecoverable error in write operation: " + e.getMessage(), (Throwable)e);
        }
    }

    private void checkSchemaVersions(DocumentParams docparams, Map<String, Object> writeContent) {
        Map verMap = (Map)ServiceImpl.getOrDefault(writeContent, X12SchemaDefs.transactionsMap(), Collections.EMPTY_MAP);
        for (String vkey : verMap.keySet()) {
            Map transMap = (Map)ServiceImpl.getOrDefault(verMap, vkey, Collections.EMPTY_MAP);
            for (String tkey : transMap.keySet()) {
                Structure struct = ((X12Config)this.getConfig()).getStructureSchema(vkey, vkey.substring(1), tkey);
                if (struct == null) {
                    throw new WriteException(MISSING_SCHEMA_ERR + tkey + " version: " + vkey);
                }
                String structVer = struct.version().version();
                this.setNullDefault(X12SchemaDefs.interControlVersionKey(), structVer.substring(0, 5), (Map)writeContent.get(SchemaJavaValues.interchangeKey()));
                List sets = (List)ServiceImpl.getOrDefault(transMap, tkey, Collections.EMPTY_LIST);
                String suffix = docparams.getVersionIdentifierSuffix();
                String groupVer = structVer + (suffix == null ? "" : suffix);
                if (sets.isEmpty()) continue;
                for (Map set : sets) {
                    set.put(SchemaJavaValues.structureSchema(), struct);
                    set.put(X12SchemaDefs.groupVersionReleaseKey(), groupVer);
                }
            }
        }
    }

    private void clearStructureSchemas(Map<String, Object> writeContent) {
        Map verMap = (Map)ServiceImpl.getOrDefault(writeContent, X12SchemaDefs.transactionsMap(), Collections.EMPTY_MAP);
        for (String vkey : verMap.keySet()) {
            Map transMap = (Map)ServiceImpl.getOrDefault(verMap, vkey, Collections.EMPTY_MAP);
            for (String tkey : transMap.keySet()) {
                List sets = (List)ServiceImpl.getOrDefault(transMap, tkey, Collections.EMPTY_LIST);
                for (Map set : sets) {
                    set.remove(SchemaJavaValues.structureSchema());
                }
            }
        }
    }
}

