/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.x12.extension.internal.service.builder;

import com.mulesoft.connectors.x12.extension.api.FunctionalGroup;
import com.mulesoft.connectors.x12.extension.api.X12WriteAttributes;
import com.mulesoft.connectors.x12.extension.internal.service.builder.FunctionalGroupBuilder;
import com.mulesoft.connectors.x12.extension.internal.service.builder.TransactionNumbersResultBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class X12WriteAttributesBuilder {
    public X12WriteAttributes build(Map<String, Object> data) {
        Map transactionSets;
        List<TransactionNumbers> transactionNumbers;
        if (data.containsKey("TransactionSets") && (transactionNumbers = this.getTransactions(transactionSets = (Map)data.getOrDefault("TransactionSets", new HashMap()), new ArrayList<TransactionNumbers>(), "")) != null && !transactionNumbers.isEmpty()) {
            TransactionNumbersResultBuilder resultBuilder = new TransactionNumbersResultBuilder();
            resultBuilder.withInterchangeControlNumber(transactionNumbers.get((int)0).interchangeNumber);
            resultBuilder.withFunctionGroups(new ArrayList<FunctionalGroup>());
            for (TransactionNumbers numbers : transactionNumbers) {
                if (!numbers.interchangeNumber.equals(resultBuilder.getInterchangeControlNumber())) continue;
                Optional<FunctionalGroup> group = resultBuilder.getFunctionGroups().stream().filter(a -> a.getGroupControlNumber().equals(numbers.groupNumber) && a.getId().equals(numbers.id)).findFirst();
                if (group.isPresent()) {
                    group.get().getSets().add(numbers.setNumber);
                    continue;
                }
                FunctionalGroup groupItem = new FunctionalGroupBuilder().withGroupCode(numbers.groupCode).withGroupControlNumber(numbers.groupNumber).withId(numbers.id).withSets(new ArrayList<String>(Arrays.asList(numbers.setNumber))).build();
                resultBuilder.getFunctionGroups().add(groupItem);
            }
            return new X12WriteAttributes(resultBuilder.build());
        }
        return new X12WriteAttributes();
    }

    private List<TransactionNumbers> getTransactions(Object data, List<TransactionNumbers> numbers, String key) {
        block5: {
            block4: {
                if (!(data instanceof Map)) break block4;
                Map map = (Map)data;
                if (map.containsKey("Group") || map.containsKey("Interchange") || map.containsKey("SetHeader")) {
                    TransactionNumbers trans = this.getTransaction(map, key);
                    numbers.add(trans);
                } else {
                    for (Map.Entry kv : map.entrySet()) {
                        this.getTransactions(kv.getValue(), numbers, (String)kv.getKey());
                    }
                }
                break block5;
            }
            if (!(data instanceof List)) break block5;
            List list = (List)data;
            for (Object item : list) {
                this.getTransactions(item, numbers, key);
            }
        }
        return numbers;
    }

    private TransactionNumbers getTransaction(Map<String, Object> data, String key) {
        TransactionNumbers result = new TransactionNumbers();
        result.id = key;
        Map group = data.getOrDefault("Group", new HashMap());
        result.groupNumber = String.valueOf(group.getOrDefault("GS06", null));
        result.groupCode = String.valueOf(group.getOrDefault("GS01", null));
        Map interchange = data.getOrDefault("Interchange", new HashMap());
        result.interchangeNumber = String.valueOf(interchange.getOrDefault("ISA13", null));
        Map setHeader = data.getOrDefault("SetHeader", new HashMap());
        result.setNumber = String.valueOf(setHeader.getOrDefault("ST02", null));
        return result;
    }

    static class TransactionNumbers {
        public String groupCode;
        public String groupNumber;
        public String interchangeNumber;
        public String setNumber;
        public String id;

        TransactionNumbers() {
        }
    }
}

